package me.snowdrop.istio.mixer.adapter.statsd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class StatsdSpecFluentImpl<A extends StatsdSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StatsdSpecFluent<A>{

    private String address;
    private Integer flushBytes;
    private Long flushDuration;
    private Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> metrics;
    private String prefix;
    private Double samplingRate;

    public StatsdSpecFluentImpl(){
    }
    public StatsdSpecFluentImpl(StatsdSpec instance){
            this.withAddress(instance.getAddress()); 
            this.withFlushBytes(instance.getFlushBytes()); 
            this.withFlushDuration(instance.getFlushDuration()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSamplingRate(instance.getSamplingRate()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public Integer getFlushBytes(){
            return this.flushBytes;
    }

    public A withFlushBytes(Integer flushBytes){
            this.flushBytes=flushBytes; return (A) this;
    }

    public Boolean hasFlushBytes(){
            return this.flushBytes != null;
    }

    public A withNewFlushBytes(String arg1){
            return (A)withFlushBytes(new Integer(arg1));
    }

    public A withNewFlushBytes(int arg1){
            return (A)withFlushBytes(new Integer(arg1));
    }

    public Long getFlushDuration(){
            return this.flushDuration;
    }

    public A withFlushDuration(Long flushDuration){
            this.flushDuration=flushDuration; return (A) this;
    }

    public Boolean hasFlushDuration(){
            return this.flushDuration != null;
    }

    public A withNewFlushDuration(String arg1){
            return (A)withFlushDuration(new Long(arg1));
    }

    public A withNewFlushDuration(long arg1){
            return (A)withFlushDuration(new Long(arg1));
    }

    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.statsd.MetricInfo>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    public String getPrefix(){
            return this.prefix;
    }

    public A withPrefix(String prefix){
            this.prefix=prefix; return (A) this;
    }

    public Boolean hasPrefix(){
            return this.prefix != null;
    }

    public Double getSamplingRate(){
            return this.samplingRate;
    }

    public A withSamplingRate(Double samplingRate){
            this.samplingRate=samplingRate; return (A) this;
    }

    public Boolean hasSamplingRate(){
            return this.samplingRate != null;
    }

    public A withNewSamplingRate(String arg1){
            return (A)withSamplingRate(new Double(arg1));
    }

    public A withNewSamplingRate(double arg1){
            return (A)withSamplingRate(new Double(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsdSpecFluentImpl that = (StatsdSpecFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (flushBytes != null ? !flushBytes.equals(that.flushBytes) :that.flushBytes != null) return false;
            if (flushDuration != null ? !flushDuration.equals(that.flushDuration) :that.flushDuration != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
            if (samplingRate != null ? !samplingRate.equals(that.samplingRate) :that.samplingRate != null) return false;
            return true;
    }




}
