package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ApiKeyListBuilder extends ApiKeyListFluentImpl<ApiKeyListBuilder> implements VisitableBuilder<ApiKeyList,ApiKeyListBuilder>{

    ApiKeyListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApiKeyListBuilder(){
            this(true);
    }
    public ApiKeyListBuilder(Boolean validationEnabled){
            this(new ApiKeyList(), validationEnabled);
    }
    public ApiKeyListBuilder(ApiKeyListFluent<?> fluent){
            this(fluent, true);
    }
    public ApiKeyListBuilder(ApiKeyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiKeyList(), validationEnabled);
    }
    public ApiKeyListBuilder(ApiKeyListFluent<?> fluent,ApiKeyList instance){
            this(fluent, instance, true);
    }
    public ApiKeyListBuilder(ApiKeyListFluent<?> fluent,ApiKeyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyListBuilder(ApiKeyList instance){
            this(instance,true);
    }
    public ApiKeyListBuilder(ApiKeyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyListBuilder(Validator validator){
            this(new ApiKeyList(), true);
    }
    public ApiKeyListBuilder(ApiKeyListFluent<?> fluent,ApiKeyList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ApiKeyListBuilder(ApiKeyList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ApiKeyList build(){
            ApiKeyList buildable = new ApiKeyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiKeyListBuilder that = (ApiKeyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
