package me.snowdrop.istio.mixer.template.apikey;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import me.snowdrop.istio.api.TimeStampFluent;
import java.lang.Long;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;

public interface ApiKeySpecFluent<A extends ApiKeySpecFluent<A>> extends Fluent<A>{


    public String getApi();
    public A withApi(String api);
    public Boolean hasApi();
    public String getApiKey();
    public A withApiKey(String apiKey);
    public Boolean hasApiKey();
    public String getApiOperation();
    public A withApiOperation(String apiOperation);
    public Boolean hasApiOperation();
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp();
    public TimeStamp buildTimestamp();
    public A withTimestamp(TimeStamp timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(Integer nanos,Long seconds);
    public ApiKeySpecFluent.TimestampNested<A> withNewTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item);
    public ApiKeySpecFluent.TimestampNested<A> editTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> editOrNewTimestamp();
    public ApiKeySpecFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item);

    public interface TimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<ApiKeySpecFluent.TimestampNested<N>>{

        
    public N and();    public N endTimestamp();
}


}
