package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AuthorizationBuilder extends AuthorizationFluentImpl<AuthorizationBuilder> implements VisitableBuilder<Authorization,AuthorizationBuilder>{

    AuthorizationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AuthorizationBuilder(){
            this(true);
    }
    public AuthorizationBuilder(Boolean validationEnabled){
            this(new Authorization(), validationEnabled);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Authorization(), validationEnabled);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance){
            this(fluent, instance, true);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationBuilder(Authorization instance){
            this(instance,true);
    }
    public AuthorizationBuilder(Authorization instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationBuilder(Validator validator){
            this(new Authorization(), true);
    }
    public AuthorizationBuilder(AuthorizationFluent<?> fluent,Authorization instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AuthorizationBuilder(Authorization instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Authorization build(){
            Authorization buildable = new Authorization(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationBuilder that = (AuthorizationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
