package me.snowdrop.istio.mixer.template.checknothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CheckNothingSpecBuilder extends CheckNothingSpecFluentImpl<CheckNothingSpecBuilder> implements VisitableBuilder<CheckNothingSpec,CheckNothingSpecBuilder>{

    CheckNothingSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CheckNothingSpecBuilder(){
            this(true);
    }
    public CheckNothingSpecBuilder(Boolean validationEnabled){
            this(new CheckNothingSpec(), validationEnabled);
    }
    public CheckNothingSpecBuilder(CheckNothingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CheckNothingSpecBuilder(CheckNothingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckNothingSpec(), validationEnabled);
    }
    public CheckNothingSpecBuilder(CheckNothingSpecFluent<?> fluent,CheckNothingSpec instance){
            this(fluent, instance, true);
    }
    public CheckNothingSpecBuilder(CheckNothingSpecFluent<?> fluent,CheckNothingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingSpecBuilder(CheckNothingSpec instance){
            this(instance,true);
    }
    public CheckNothingSpecBuilder(CheckNothingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingSpecBuilder(Validator validator){
            this(new CheckNothingSpec(), true);
    }
    public CheckNothingSpecBuilder(CheckNothingSpecFluent<?> fluent,CheckNothingSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CheckNothingSpecBuilder(CheckNothingSpec instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CheckNothingSpec build(){
            CheckNothingSpec buildable = new CheckNothingSpec(fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckNothingSpecBuilder that = (CheckNothingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
