package me.snowdrop.istio.mixer.template.edge;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface EdgeFluent<A extends EdgeFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public EdgeFluent.MetadataNested<A> withNewMetadata();
    public EdgeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EdgeFluent.MetadataNested<A> editMetadata();
    public EdgeFluent.MetadataNested<A> editOrNewMetadata();
    public EdgeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public EdgeSpec getSpec();
    public EdgeSpec buildSpec();
    public A withSpec(EdgeSpec spec);
    public Boolean hasSpec();
    public EdgeFluent.SpecNested<A> withNewSpec();
    public EdgeFluent.SpecNested<A> withNewSpecLike(EdgeSpec item);
    public EdgeFluent.SpecNested<A> editSpec();
    public EdgeFluent.SpecNested<A> editOrNewSpec();
    public EdgeFluent.SpecNested<A> editOrNewSpecLike(EdgeSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<EdgeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,EdgeSpecFluent<EdgeFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
