package me.snowdrop.istio.mixer.template.edge;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class EdgeListBuilder extends EdgeListFluentImpl<EdgeListBuilder> implements VisitableBuilder<EdgeList,EdgeListBuilder>{

    EdgeListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EdgeListBuilder(){
            this(true);
    }
    public EdgeListBuilder(Boolean validationEnabled){
            this(new EdgeList(), validationEnabled);
    }
    public EdgeListBuilder(EdgeListFluent<?> fluent){
            this(fluent, true);
    }
    public EdgeListBuilder(EdgeListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EdgeList(), validationEnabled);
    }
    public EdgeListBuilder(EdgeListFluent<?> fluent,EdgeList instance){
            this(fluent, instance, true);
    }
    public EdgeListBuilder(EdgeListFluent<?> fluent,EdgeList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public EdgeListBuilder(EdgeList instance){
            this(instance,true);
    }
    public EdgeListBuilder(EdgeList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public EdgeListBuilder(Validator validator){
            this(new EdgeList(), true);
    }
    public EdgeListBuilder(EdgeListFluent<?> fluent,EdgeList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public EdgeListBuilder(EdgeList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public EdgeList build(){
            EdgeList buildable = new EdgeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EdgeListBuilder that = (EdgeListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
