package me.snowdrop.istio.mixer.template.edge;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import me.snowdrop.istio.api.TimeStampFluent;
import java.lang.Long;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;

public interface EdgeSpecFluent<A extends EdgeSpecFluent<A>> extends Fluent<A>{


    public String getApiProtocol();
    public A withApiProtocol(String apiProtocol);
    public Boolean hasApiProtocol();
    public String getContextProtocol();
    public A withContextProtocol(String contextProtocol);
    public Boolean hasContextProtocol();
    public String getDestinationOwner();
    public A withDestinationOwner(String destinationOwner);
    public Boolean hasDestinationOwner();
    public String getDestinationUid();
    public A withDestinationUid(String destinationUid);
    public Boolean hasDestinationUid();
    public String getDestinationWorkloadName();
    public A withDestinationWorkloadName(String destinationWorkloadName);
    public Boolean hasDestinationWorkloadName();
    public String getDestinationWorkloadNamespace();
    public A withDestinationWorkloadNamespace(String destinationWorkloadNamespace);
    public Boolean hasDestinationWorkloadNamespace();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public String getSourceOwner();
    public A withSourceOwner(String sourceOwner);
    public Boolean hasSourceOwner();
    public String getSourceUid();
    public A withSourceUid(String sourceUid);
    public Boolean hasSourceUid();
    public String getSourceWorkloadName();
    public A withSourceWorkloadName(String sourceWorkloadName);
    public Boolean hasSourceWorkloadName();
    public String getSourceWorkloadNamespace();
    public A withSourceWorkloadNamespace(String sourceWorkloadNamespace);
    public Boolean hasSourceWorkloadNamespace();
    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp();
    public TimeStamp buildTimestamp();
    public A withTimestamp(TimeStamp timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(Integer nanos,Long seconds);
    public EdgeSpecFluent.TimestampNested<A> withNewTimestamp();
    public EdgeSpecFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item);
    public EdgeSpecFluent.TimestampNested<A> editTimestamp();
    public EdgeSpecFluent.TimestampNested<A> editOrNewTimestamp();
    public EdgeSpecFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item);

    public interface TimestampNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<EdgeSpecFluent.TimestampNested<N>>{

        
    public N and();    public N endTimestamp();
}


}
