package me.snowdrop.istio.mixer.template.edge;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import me.snowdrop.istio.api.TimeStampFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;

public class EdgeSpecFluentImpl<A extends EdgeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EdgeSpecFluent<A>{

    private String apiProtocol;
    private String contextProtocol;
    private String destinationOwner;
    private String destinationUid;
    private String destinationWorkloadName;
    private String destinationWorkloadNamespace;
    private String name;
    private String sourceOwner;
    private String sourceUid;
    private String sourceWorkloadName;
    private String sourceWorkloadNamespace;
    private TimeStampBuilder timestamp;

    public EdgeSpecFluentImpl(){
    }
    public EdgeSpecFluentImpl(EdgeSpec instance){
            this.withApiProtocol(instance.getApiProtocol()); 
            this.withContextProtocol(instance.getContextProtocol()); 
            this.withDestinationOwner(instance.getDestinationOwner()); 
            this.withDestinationUid(instance.getDestinationUid()); 
            this.withDestinationWorkloadName(instance.getDestinationWorkloadName()); 
            this.withDestinationWorkloadNamespace(instance.getDestinationWorkloadNamespace()); 
            this.withName(instance.getName()); 
            this.withSourceOwner(instance.getSourceOwner()); 
            this.withSourceUid(instance.getSourceUid()); 
            this.withSourceWorkloadName(instance.getSourceWorkloadName()); 
            this.withSourceWorkloadNamespace(instance.getSourceWorkloadNamespace()); 
            this.withTimestamp(instance.getTimestamp()); 
    }

    public String getApiProtocol(){
            return this.apiProtocol;
    }

    public A withApiProtocol(String apiProtocol){
            this.apiProtocol=apiProtocol; return (A) this;
    }

    public Boolean hasApiProtocol(){
            return this.apiProtocol != null;
    }

    public String getContextProtocol(){
            return this.contextProtocol;
    }

    public A withContextProtocol(String contextProtocol){
            this.contextProtocol=contextProtocol; return (A) this;
    }

    public Boolean hasContextProtocol(){
            return this.contextProtocol != null;
    }

    public String getDestinationOwner(){
            return this.destinationOwner;
    }

    public A withDestinationOwner(String destinationOwner){
            this.destinationOwner=destinationOwner; return (A) this;
    }

    public Boolean hasDestinationOwner(){
            return this.destinationOwner != null;
    }

    public String getDestinationUid(){
            return this.destinationUid;
    }

    public A withDestinationUid(String destinationUid){
            this.destinationUid=destinationUid; return (A) this;
    }

    public Boolean hasDestinationUid(){
            return this.destinationUid != null;
    }

    public String getDestinationWorkloadName(){
            return this.destinationWorkloadName;
    }

    public A withDestinationWorkloadName(String destinationWorkloadName){
            this.destinationWorkloadName=destinationWorkloadName; return (A) this;
    }

    public Boolean hasDestinationWorkloadName(){
            return this.destinationWorkloadName != null;
    }

    public String getDestinationWorkloadNamespace(){
            return this.destinationWorkloadNamespace;
    }

    public A withDestinationWorkloadNamespace(String destinationWorkloadNamespace){
            this.destinationWorkloadNamespace=destinationWorkloadNamespace; return (A) this;
    }

    public Boolean hasDestinationWorkloadNamespace(){
            return this.destinationWorkloadNamespace != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public String getSourceOwner(){
            return this.sourceOwner;
    }

    public A withSourceOwner(String sourceOwner){
            this.sourceOwner=sourceOwner; return (A) this;
    }

    public Boolean hasSourceOwner(){
            return this.sourceOwner != null;
    }

    public String getSourceUid(){
            return this.sourceUid;
    }

    public A withSourceUid(String sourceUid){
            this.sourceUid=sourceUid; return (A) this;
    }

    public Boolean hasSourceUid(){
            return this.sourceUid != null;
    }

    public String getSourceWorkloadName(){
            return this.sourceWorkloadName;
    }

    public A withSourceWorkloadName(String sourceWorkloadName){
            this.sourceWorkloadName=sourceWorkloadName; return (A) this;
    }

    public Boolean hasSourceWorkloadName(){
            return this.sourceWorkloadName != null;
    }

    public String getSourceWorkloadNamespace(){
            return this.sourceWorkloadNamespace;
    }

    public A withSourceWorkloadNamespace(String sourceWorkloadNamespace){
            this.sourceWorkloadNamespace=sourceWorkloadNamespace; return (A) this;
    }

    public Boolean hasSourceWorkloadNamespace(){
            return this.sourceWorkloadNamespace != null;
    }

    
/**
 * This method has been deprecated, please use method buildTimestamp instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public TimeStamp buildTimestamp(){
            return this.timestamp!=null?this.timestamp.build():null;
    }

    public A withTimestamp(TimeStamp timestamp){
            _visitables.remove(this.timestamp);
            if (timestamp!=null){ this.timestamp= new TimeStampBuilder(timestamp); _visitables.add(this.timestamp);} return (A) this;
    }

    public Boolean hasTimestamp(){
            return this.timestamp != null;
    }

    public A withNewTimestamp(Integer nanos,Long seconds){
            return (A)withTimestamp(new TimeStamp(nanos, seconds));
    }

    public EdgeSpecFluent.TimestampNested<A> withNewTimestamp(){
            return new TimestampNestedImpl();
    }

    public EdgeSpecFluent.TimestampNested<A> withNewTimestampLike(TimeStamp item){
            return new TimestampNestedImpl(item);
    }

    public EdgeSpecFluent.TimestampNested<A> editTimestamp(){
            return withNewTimestampLike(getTimestamp());
    }

    public EdgeSpecFluent.TimestampNested<A> editOrNewTimestamp(){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): new TimeStampBuilder().build());
    }

    public EdgeSpecFluent.TimestampNested<A> editOrNewTimestampLike(TimeStamp item){
            return withNewTimestampLike(getTimestamp() != null ? getTimestamp(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EdgeSpecFluentImpl that = (EdgeSpecFluentImpl) o;
            if (apiProtocol != null ? !apiProtocol.equals(that.apiProtocol) :that.apiProtocol != null) return false;
            if (contextProtocol != null ? !contextProtocol.equals(that.contextProtocol) :that.contextProtocol != null) return false;
            if (destinationOwner != null ? !destinationOwner.equals(that.destinationOwner) :that.destinationOwner != null) return false;
            if (destinationUid != null ? !destinationUid.equals(that.destinationUid) :that.destinationUid != null) return false;
            if (destinationWorkloadName != null ? !destinationWorkloadName.equals(that.destinationWorkloadName) :that.destinationWorkloadName != null) return false;
            if (destinationWorkloadNamespace != null ? !destinationWorkloadNamespace.equals(that.destinationWorkloadNamespace) :that.destinationWorkloadNamespace != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (sourceOwner != null ? !sourceOwner.equals(that.sourceOwner) :that.sourceOwner != null) return false;
            if (sourceUid != null ? !sourceUid.equals(that.sourceUid) :that.sourceUid != null) return false;
            if (sourceWorkloadName != null ? !sourceWorkloadName.equals(that.sourceWorkloadName) :that.sourceWorkloadName != null) return false;
            if (sourceWorkloadNamespace != null ? !sourceWorkloadNamespace.equals(that.sourceWorkloadNamespace) :that.sourceWorkloadNamespace != null) return false;
            if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
            return true;
    }


    public class TimestampNestedImpl<N> extends TimeStampFluentImpl<EdgeSpecFluent.TimestampNested<N>> implements EdgeSpecFluent.TimestampNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeStampBuilder builder;
    
            TimestampNestedImpl(TimeStamp item){
                    this.builder = new TimeStampBuilder(this, item);
            }
            TimestampNestedImpl(){
                    this.builder = new TimeStampBuilder(this);
            }
    
    public N and(){
            return (N) EdgeSpecFluentImpl.this.withTimestamp(builder.build());
    }
    public N endTimestamp(){
            return and();
    }

}


}
