package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ListEntryBuilder extends ListEntryFluentImpl<ListEntryBuilder> implements VisitableBuilder<ListEntry,ListEntryBuilder>{

    ListEntryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ListEntryBuilder(){
            this(true);
    }
    public ListEntryBuilder(Boolean validationEnabled){
            this(new ListEntry(), validationEnabled);
    }
    public ListEntryBuilder(ListEntryFluent<?> fluent){
            this(fluent, true);
    }
    public ListEntryBuilder(ListEntryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListEntry(), validationEnabled);
    }
    public ListEntryBuilder(ListEntryFluent<?> fluent,ListEntry instance){
            this(fluent, instance, true);
    }
    public ListEntryBuilder(ListEntryFluent<?> fluent,ListEntry instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListEntryBuilder(ListEntry instance){
            this(instance,true);
    }
    public ListEntryBuilder(ListEntry instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListEntryBuilder(Validator validator){
            this(new ListEntry(), true);
    }
    public ListEntryBuilder(ListEntryFluent<?> fluent,ListEntry instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ListEntryBuilder(ListEntry instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ListEntry build(){
            ListEntry buildable = new ListEntry(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListEntryBuilder that = (ListEntryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
