package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ListEntryFluentImpl<A extends ListEntryFluent<A>> extends BaseFluent<A> implements ListEntryFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ListEntrySpecBuilder spec;

    public ListEntryFluentImpl(){
    }
    public ListEntryFluentImpl(ListEntry instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ListEntryFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ListEntryFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ListEntryFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ListEntryFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ListEntryFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ListEntrySpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ListEntrySpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ListEntrySpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new ListEntrySpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public A withNewSpec(String name,String value){
            return (A)withSpec(new ListEntrySpec(name, value));
    }

    public ListEntryFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ListEntryFluent.SpecNested<A> withNewSpecLike(ListEntrySpec item){
            return new SpecNestedImpl(item);
    }

    public ListEntryFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ListEntryFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ListEntrySpecBuilder().build());
    }

    public ListEntryFluent.SpecNested<A> editOrNewSpecLike(ListEntrySpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListEntryFluentImpl that = (ListEntryFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ListEntryFluent.MetadataNested<N>> implements ListEntryFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ListEntryFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ListEntrySpecFluentImpl<ListEntryFluent.SpecNested<N>> implements ListEntryFluent.SpecNested<N>,Nested<N>{

            private final ListEntrySpecBuilder builder;
    
            SpecNestedImpl(ListEntrySpec item){
                    this.builder = new ListEntrySpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ListEntrySpecBuilder(this);
            }
    
    public N and(){
            return (N) ListEntryFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
