package me.snowdrop.istio.mixer.template.listentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ListEntrySpecBuilder extends ListEntrySpecFluentImpl<ListEntrySpecBuilder> implements VisitableBuilder<ListEntrySpec,ListEntrySpecBuilder>{

    ListEntrySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ListEntrySpecBuilder(){
            this(true);
    }
    public ListEntrySpecBuilder(Boolean validationEnabled){
            this(new ListEntrySpec(), validationEnabled);
    }
    public ListEntrySpecBuilder(ListEntrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public ListEntrySpecBuilder(ListEntrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListEntrySpec(), validationEnabled);
    }
    public ListEntrySpecBuilder(ListEntrySpecFluent<?> fluent,ListEntrySpec instance){
            this(fluent, instance, true);
    }
    public ListEntrySpecBuilder(ListEntrySpecFluent<?> fluent,ListEntrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListEntrySpecBuilder(ListEntrySpec instance){
            this(instance,true);
    }
    public ListEntrySpecBuilder(ListEntrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListEntrySpecBuilder(Validator validator){
            this(new ListEntrySpec(), true);
    }
    public ListEntrySpecBuilder(ListEntrySpecFluent<?> fluent,ListEntrySpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withValue(instance.getValue()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ListEntrySpecBuilder(ListEntrySpec instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ListEntrySpec build(){
            ListEntrySpec buildable = new ListEntrySpec(fluent.getName(),fluent.getValue());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListEntrySpecBuilder that = (ListEntrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
