package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface MetricFluent<A extends MetricFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public MetricFluent.MetadataNested<A> withNewMetadata();
    public MetricFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public MetricFluent.MetadataNested<A> editMetadata();
    public MetricFluent.MetadataNested<A> editOrNewMetadata();
    public MetricFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public MetricSpec getSpec();
    public MetricSpec buildSpec();
    public A withSpec(MetricSpec spec);
    public Boolean hasSpec();
    public MetricFluent.SpecNested<A> withNewSpec();
    public MetricFluent.SpecNested<A> withNewSpecLike(MetricSpec item);
    public MetricFluent.SpecNested<A> editSpec();
    public MetricFluent.SpecNested<A> editOrNewSpec();
    public MetricFluent.SpecNested<A> editOrNewSpecLike(MetricSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetricFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,MetricSpecFluent<MetricFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
