
package me.snowdrop.istio.mixer.template.metric;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "monitoredResourceDimensions",
    "monitoredResourceType",
    "name",
    "value"
})
@IstioKind(name = "metric", plural = "metrics")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class MetricSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions;
    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions;
    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    @JsonPropertyDescription("")
    private java.lang.String monitoredResourceType;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    @Valid
    private me.snowdrop.istio.api.cexl.TypedValue value;
    private final static long serialVersionUID = 369182450892763323L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricSpec() {
    }

    /**
     * 
     * @param monitoredResourceType
     * @param name
     * @param monitoredResourceDimensions
     * @param value
     * @param dimensions
     */
    public MetricSpec(Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions, Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions, java.lang.String monitoredResourceType, java.lang.String name, me.snowdrop.istio.api.cexl.TypedValue value) {
        super();
        this.dimensions = dimensions;
        this.monitoredResourceDimensions = monitoredResourceDimensions;
        this.monitoredResourceType = monitoredResourceType;
        this.name = name;
        this.value = value;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getDimensions() {
        return dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public void setDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    public Map<String, me.snowdrop.istio.api.cexl.TypedValue> getMonitoredResourceDimensions() {
        return monitoredResourceDimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceDimensions")
    public void setMonitoredResourceDimensions(Map<String, me.snowdrop.istio.api.cexl.TypedValue> monitoredResourceDimensions) {
        this.monitoredResourceDimensions = monitoredResourceDimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    public java.lang.String getMonitoredResourceType() {
        return monitoredResourceType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("monitoredResourceType")
    public void setMonitoredResourceType(java.lang.String monitoredResourceType) {
        this.monitoredResourceType = monitoredResourceType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("value")
    public me.snowdrop.istio.api.cexl.TypedValue getValue() {
        return value;
    }

    /**
     * 
     * 
     */
    @JsonProperty("value")
    public void setValue(me.snowdrop.istio.api.cexl.TypedValue value) {
        this.value = value;
    }

}
