package me.snowdrop.istio.mixer.template.quota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class QuotaBuilder extends me.snowdrop.istio.mixer.template.quota.QuotaFluentImpl<me.snowdrop.istio.mixer.template.quota.QuotaBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.template.quota.Quota,me.snowdrop.istio.mixer.template.quota.QuotaBuilder>{

    me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuotaBuilder(){
            this(true);
    }
    public QuotaBuilder(Boolean validationEnabled){
            this(new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.template.quota.Quota instance){
            this(fluent, instance, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.template.quota.Quota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.Quota instance){
            this(instance,true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.Quota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(Validator validator){
            this(new Quota(), true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.template.quota.Quota instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.template.quota.Quota instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.mixer.template.quota.Quota build(){
            Quota buildable = new Quota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaBuilder that = (QuotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
