package me.snowdrop.istio.mixer.template.tracespan;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface TraceSpanFluent<A extends TraceSpanFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public TraceSpanFluent.MetadataNested<A> withNewMetadata();
    public TraceSpanFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public TraceSpanFluent.MetadataNested<A> editMetadata();
    public TraceSpanFluent.MetadataNested<A> editOrNewMetadata();
    public TraceSpanFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public TraceSpanSpec getSpec();
    public TraceSpanSpec buildSpec();
    public A withSpec(TraceSpanSpec spec);
    public Boolean hasSpec();
    public TraceSpanFluent.SpecNested<A> withNewSpec();
    public TraceSpanFluent.SpecNested<A> withNewSpecLike(TraceSpanSpec item);
    public TraceSpanFluent.SpecNested<A> editSpec();
    public TraceSpanFluent.SpecNested<A> editOrNewSpec();
    public TraceSpanFluent.SpecNested<A> editOrNewSpecLike(TraceSpanSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<TraceSpanFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,TraceSpanSpecFluent<TraceSpanFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
