package me.snowdrop.istio.mixer.template.tracespan;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface TraceSpanListFluent<A extends TraceSpanListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,TraceSpan item);
    public A setToItems(int index,TraceSpan item);
    public A addToItems(TraceSpan... items);
    public A addAllToItems(Collection<TraceSpan> items);
    public A removeFromItems(TraceSpan... items);
    public A removeAllFromItems(Collection<TraceSpan> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<TraceSpan> getItems();
    public List<TraceSpan> buildItems();
    public TraceSpan buildItem(int index);
    public TraceSpan buildFirstItem();
    public TraceSpan buildLastItem();
    public TraceSpan buildMatchingItem(Predicate<TraceSpanBuilder> predicate);
    public A withItems(List<TraceSpan> items);
    public A withItems(TraceSpan... items);
    public Boolean hasItems();
    public TraceSpanListFluent.ItemsNested<A> addNewItem();
    public TraceSpanListFluent.ItemsNested<A> addNewItemLike(TraceSpan item);
    public TraceSpanListFluent.ItemsNested<A> setNewItemLike(int index,TraceSpan item);
    public TraceSpanListFluent.ItemsNested<A> editItem(int index);
    public TraceSpanListFluent.ItemsNested<A> editFirstItem();
    public TraceSpanListFluent.ItemsNested<A> editLastItem();
    public TraceSpanListFluent.ItemsNested<A> editMatchingItem(Predicate<TraceSpanBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,TraceSpanFluent<TraceSpanListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
