
package me.snowdrop.istio.mixer.template.tracespan;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "clientSpan",
    "endTime",
    "httpStatusCode",
    "name",
    "parentSpanId",
    "rewriteClientSpanId",
    "spanId",
    "spanName",
    "spanTags",
    "startTime",
    "traceId"
})
@IstioKind(name = "tracespan", plural = "tracespans")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class TraceSpanSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    @JsonPropertyDescription("")
    private Boolean clientSpan;
    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    @JsonPropertyDescription("")
    @Valid
    private TimeStamp endTime;
    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    @JsonPropertyDescription("")
    private Long httpStatusCode;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    @JsonPropertyDescription("")
    private java.lang.String parentSpanId;
    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    @JsonPropertyDescription("")
    private Boolean rewriteClientSpanId;
    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    @JsonPropertyDescription("")
    private java.lang.String spanId;
    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    @JsonPropertyDescription("")
    private java.lang.String spanName;
    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, TypedValue> spanTags;
    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    @JsonPropertyDescription("")
    @Valid
    private TimeStamp startTime;
    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    @JsonPropertyDescription("")
    private java.lang.String traceId;
    private final static long serialVersionUID = -3323307949910886857L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TraceSpanSpec() {
    }

    /**
     * 
     * @param clientSpan
     * @param spanId
     * @param traceId
     * @param rewriteClientSpanId
     * @param name
     * @param startTime
     * @param endTime
     * @param parentSpanId
     * @param httpStatusCode
     * @param spanName
     * @param spanTags
     */
    public TraceSpanSpec(Boolean clientSpan, TimeStamp endTime, Long httpStatusCode, java.lang.String name, java.lang.String parentSpanId, Boolean rewriteClientSpanId, java.lang.String spanId, java.lang.String spanName, Map<String, TypedValue> spanTags, TimeStamp startTime, java.lang.String traceId) {
        super();
        this.clientSpan = clientSpan;
        this.endTime = endTime;
        this.httpStatusCode = httpStatusCode;
        this.name = name;
        this.parentSpanId = parentSpanId;
        this.rewriteClientSpanId = rewriteClientSpanId;
        this.spanId = spanId;
        this.spanName = spanName;
        this.spanTags = spanTags;
        this.startTime = startTime;
        this.traceId = traceId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    public Boolean getClientSpan() {
        return clientSpan;
    }

    /**
     * 
     * 
     */
    @JsonProperty("clientSpan")
    public void setClientSpan(Boolean clientSpan) {
        this.clientSpan = clientSpan;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    public TimeStamp getEndTime() {
        return endTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endTime")
    public void setEndTime(TimeStamp endTime) {
        this.endTime = endTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    public Long getHttpStatusCode() {
        return httpStatusCode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpStatusCode")
    public void setHttpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    public java.lang.String getParentSpanId() {
        return parentSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentSpanId")
    public void setParentSpanId(java.lang.String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    public Boolean getRewriteClientSpanId() {
        return rewriteClientSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    public void setRewriteClientSpanId(Boolean rewriteClientSpanId) {
        this.rewriteClientSpanId = rewriteClientSpanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    public java.lang.String getSpanId() {
        return spanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanId")
    public void setSpanId(java.lang.String spanId) {
        this.spanId = spanId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    public java.lang.String getSpanName() {
        return spanName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanName")
    public void setSpanName(java.lang.String spanName) {
        this.spanName = spanName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    public Map<String, TypedValue> getSpanTags() {
        return spanTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("spanTags")
    public void setSpanTags(Map<String, TypedValue> spanTags) {
        this.spanTags = spanTags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    public TimeStamp getStartTime() {
        return startTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("startTime")
    public void setStartTime(TimeStamp startTime) {
        this.startTime = startTime;
    }

    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    public java.lang.String getTraceId() {
        return traceId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("traceId")
    public void setTraceId(java.lang.String traceId) {
        this.traceId = traceId;
    }

}
