package me.snowdrop.istio.mixer.template.tracespan;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TraceSpanSpecBuilder extends TraceSpanSpecFluentImpl<TraceSpanSpecBuilder> implements VisitableBuilder<TraceSpanSpec,TraceSpanSpecBuilder>{

    TraceSpanSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TraceSpanSpecBuilder(){
            this(true);
    }
    public TraceSpanSpecBuilder(Boolean validationEnabled){
            this(new TraceSpanSpec(), validationEnabled);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TraceSpanSpec(), validationEnabled);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,TraceSpanSpec instance){
            this(fluent, instance, true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,TraceSpanSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientSpan(instance.getClientSpan()); 
            fluent.withEndTime(instance.getEndTime()); 
            fluent.withHttpStatusCode(instance.getHttpStatusCode()); 
            fluent.withName(instance.getName()); 
            fluent.withParentSpanId(instance.getParentSpanId()); 
            fluent.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            fluent.withSpanId(instance.getSpanId()); 
            fluent.withSpanName(instance.getSpanName()); 
            fluent.withSpanTags(instance.getSpanTags()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withTraceId(instance.getTraceId()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceSpanSpecBuilder(TraceSpanSpec instance){
            this(instance,true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientSpan(instance.getClientSpan()); 
            this.withEndTime(instance.getEndTime()); 
            this.withHttpStatusCode(instance.getHttpStatusCode()); 
            this.withName(instance.getName()); 
            this.withParentSpanId(instance.getParentSpanId()); 
            this.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            this.withSpanId(instance.getSpanId()); 
            this.withSpanName(instance.getSpanName()); 
            this.withSpanTags(instance.getSpanTags()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTraceId(instance.getTraceId()); 
            this.validationEnabled = validationEnabled; 
    }
    public TraceSpanSpecBuilder(Validator validator){
            this(new TraceSpanSpec(), true);
    }
    public TraceSpanSpecBuilder(TraceSpanSpecFluent<?> fluent,TraceSpanSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withClientSpan(instance.getClientSpan()); 
            fluent.withEndTime(instance.getEndTime()); 
            fluent.withHttpStatusCode(instance.getHttpStatusCode()); 
            fluent.withName(instance.getName()); 
            fluent.withParentSpanId(instance.getParentSpanId()); 
            fluent.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            fluent.withSpanId(instance.getSpanId()); 
            fluent.withSpanName(instance.getSpanName()); 
            fluent.withSpanTags(instance.getSpanTags()); 
            fluent.withStartTime(instance.getStartTime()); 
            fluent.withTraceId(instance.getTraceId()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TraceSpanSpecBuilder(TraceSpanSpec instance,Validator validator){
            this.fluent = this; 
            this.withClientSpan(instance.getClientSpan()); 
            this.withEndTime(instance.getEndTime()); 
            this.withHttpStatusCode(instance.getHttpStatusCode()); 
            this.withName(instance.getName()); 
            this.withParentSpanId(instance.getParentSpanId()); 
            this.withRewriteClientSpanId(instance.getRewriteClientSpanId()); 
            this.withSpanId(instance.getSpanId()); 
            this.withSpanName(instance.getSpanName()); 
            this.withSpanTags(instance.getSpanTags()); 
            this.withStartTime(instance.getStartTime()); 
            this.withTraceId(instance.getTraceId()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public TraceSpanSpec build(){
            TraceSpanSpec buildable = new TraceSpanSpec(fluent.isClientSpan(),fluent.getEndTime(),fluent.getHttpStatusCode(),fluent.getName(),fluent.getParentSpanId(),fluent.isRewriteClientSpanId(),fluent.getSpanId(),fluent.getSpanName(),fluent.getSpanTags(),fluent.getStartTime(),fluent.getTraceId());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceSpanSpecBuilder that = (TraceSpanSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
