/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.mevenide.tags.AbstractMevenideTag;

public class AdaptVersionTag
extends AbstractMevenideTag {
    private String version;
    private String var;

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.version, "version");
        this.checkAttribute(this.var, "var");
        String newVersion = this.adapt();
        this.context.setVariable(this.var, (Object)newVersion);
    }

    public String adapt() {
        String validValues = "0123456789.";
        String newVersion = "";
        char lastConcatenatedChar = '-';
        int i = 0;
        while (i < this.version.length()) {
            if (validValues.indexOf(this.version.charAt(i)) >= 0) {
                if (Character.isDigit(lastConcatenatedChar)) {
                    if (Character.isDigit(this.version.charAt(i))) {
                        newVersion = String.valueOf(newVersion) + ".";
                    }
                    lastConcatenatedChar = this.version.charAt(i);
                    newVersion = String.valueOf(newVersion) + lastConcatenatedChar;
                } else if (Character.isDigit(this.version.charAt(i))) {
                    lastConcatenatedChar = this.version.charAt(i);
                    newVersion = String.valueOf(newVersion) + lastConcatenatedChar;
                }
            }
            ++i;
        }
        if (newVersion.endsWith(".")) {
            newVersion = newVersion.substring(0, newVersion.length() - 1);
        }
        if (newVersion.trim().equals("")) {
            newVersion = "0.0.0";
        } else if (!this.version.equals("SNAPSHOT") && this.version.indexOf("SNAPSHOT") >= 0) {
            newVersion = String.valueOf(newVersion) + "." + new SimpleDateFormat("yyyyMMdd").format(new Date());
        }
        int digitNumber = this.countNumbers(newVersion);
        while (digitNumber < 3) {
            newVersion = String.valueOf(newVersion) + ".0";
            ++digitNumber;
        }
        return newVersion;
    }

    private int countNumbers(String version) {
        int u = 0;
        int i = 0;
        while (i < version.length()) {
            if (Character.isDigit(version.charAt(i))) {
                ++u;
            }
            ++i;
        }
        return u;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

