/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.mevenide.tags.AbstractMevenideTag;
import org.mevenide.tags.InvalidDirectoryException;

public class UpdatePluginLibsTag
extends AbstractMevenideTag {
    private static final Log log;
    private static final String RUNTIME_ELEM = "runtime";
    private static final String REQUIRES_ELEM = "requires";
    private static final String LIBRARY_ELEM = "library";
    private static final String EXPORT_ELEM = "export";
    private static final String IMPORT_ELEM = "import";
    private static final String PACKAGES_ELEM = "packages";
    private static final String NAME_ATTR = "name";
    private static final String PREFIXES_ATTR = "prefixes";
    private static final String PLUGIN_ATTR = "plugin";
    private static final String TEMP_DIR_PROPERTY = "maven.eclipse.plugin.temp.dir";
    private static final String BUNDLE_LIB_DIR = "maven.eclipse.plugin.bundle.lib.dir";
    private static final String DESCRIPTOR_DIR_PROPERTY = "maven.eclipse.plugin.src.dir";
    private static final String BUNDLE_DEPENDENCY_PROPERTY = "eclipse.plugin.bundle";
    private static final String BUILD_MODE_PROPERTY = "maven.eclipse.plugin.build.mode";
    private static final String DEFAULT_EXPORT_PROPERTY = "maven.eclipse.plugin.export.default";
    private static final String DEPENDENCY_PREFIXES_PROPERTY = "eclipse.plugin.packages";
    private static final String DEPENDENCY_EXPORT_PROPERTY = "eclipse.plugin.export";
    private static final String PLUGIN_FILENAME = "plugin.xml";
    private static final String TRUE = "true";
    private static final String FS_SEPARATOR = "/";
    private static final String STAR_PATTERN = "*";
    private static final String XML_INDENT = "    ";
    private static final String SHOULD_BUNDLE = "bundle";
    private Project pom;
    private Document descriptor;
    private String bundledLibraryDir;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        try {
            this.setUpDescriptor();
            List artifacts = this.pom.getArtifacts();
            int i = 0;
            while (i < artifacts.size()) {
                Artifact artifact = (Artifact)artifacts.get(i);
                this.updateDescriptor(artifact);
                ++i;
            }
            this.outputDescriptor();
        }
        catch (Exception exc) {
            throw new JellyTagException((Throwable)exc);
        }
    }

    void updateDescriptor(Artifact artifact) throws InvalidDirectoryException {
        boolean shouldBundleDependency = TRUE.equals(artifact.getDependency().getProperty(BUNDLE_DEPENDENCY_PROPERTY));
        log.debug((Object)(artifact.getDependency() + " > ${eclipse.plugin.bundle} = " + shouldBundleDependency));
        if (shouldBundleDependency) {
            if (!this.getBundleMode().equals(SHOULD_BUNDLE)) {
                this.updateRequires(artifact);
            } else {
                this.updateRuntime(artifact);
            }
        }
    }

    void updateRequires(Artifact artifact) {
        Element pluginElem = this.descriptor.getRootElement();
        this.assertRequiresPresent();
        if (!this.isRequiredPluginDeclared(artifact)) {
            this.addRequiresPlugin(artifact);
        }
    }

    void updateRuntime(Artifact artifact) throws InvalidDirectoryException {
        Element pluginElem = this.descriptor.getRootElement();
        if (new File(this.bundledLibraryDir).isAbsolute()) {
            throw new InvalidDirectoryException(this.bundledLibraryDir, true, BUNDLE_LIB_DIR);
        }
        this.assertRuntimePresent();
        if (!this.isLibraryDeclared(artifact)) {
            this.addRuntimeLibrary(artifact);
        }
    }

    void addRequiresPlugin(Artifact artifact) {
        Element importPluginElem = new Element(IMPORT_ELEM);
        importPluginElem.setAttribute(PLUGIN_ATTR, this.getPluginName(artifact));
        Element pluginElem = this.descriptor.getRootElement();
        pluginElem.getChild(REQUIRES_ELEM).addContent(importPluginElem);
    }

    String getPluginName(Artifact artifact) {
        return artifact.getDependency().getGroupId();
    }

    void addRuntimeLibrary(Artifact artifact) {
        Element artifactLibraryElem = new Element(LIBRARY_ELEM);
        artifactLibraryElem.setAttribute(NAME_ATTR, String.valueOf(this.bundledLibraryDir) + FS_SEPARATOR + new File(artifact.getPath()).getName());
        if (this.getExport(artifact) != null && !this.getExport(artifact).trim().equals("")) {
            Element exportElem = new Element(EXPORT_ELEM);
            exportElem.setAttribute(NAME_ATTR, STAR_PATTERN);
            artifactLibraryElem.addContent(exportElem);
        }
        if (this.getPackagesPrefixes(artifact) != null && !this.getPackagesPrefixes(artifact).trim().equals("")) {
            Element packagesElem = new Element(PACKAGES_ELEM);
            packagesElem.setAttribute(PREFIXES_ATTR, this.getPackagesPrefixes(artifact).trim());
            artifactLibraryElem.addContent(packagesElem);
        }
        Element pluginElem = this.descriptor.getRootElement();
        pluginElem.getChild(RUNTIME_ELEM).addContent(artifactLibraryElem);
    }

    void assertRuntimePresent() {
        Element pluginElem = this.descriptor.getRootElement();
        Element runtimeElem = pluginElem.getChild(RUNTIME_ELEM);
        if (runtimeElem == null) {
            runtimeElem = new Element(RUNTIME_ELEM);
            pluginElem.addContent(runtimeElem);
        }
    }

    void assertRequiresPresent() {
        Element pluginElem = this.descriptor.getRootElement();
        Element requiresElem = pluginElem.getChild(REQUIRES_ELEM);
        if (requiresElem == null) {
            requiresElem = new Element(REQUIRES_ELEM);
            pluginElem.addContent(requiresElem);
        }
    }

    boolean isRequiredPluginDeclared(Artifact artifact) {
        Element requiresElem = this.descriptor.getRootElement().getChild(REQUIRES_ELEM);
        List importElems = requiresElem.getChildren(IMPORT_ELEM);
        boolean isRequiredPluginPresent = false;
        int i = 0;
        while (i < importElems.size()) {
            Element theImport = (Element)importElems.get(i);
            String pluginName = theImport.getAttributeValue(PLUGIN_ATTR);
            if (pluginName != null && pluginName.equals(artifact.getDependency().getGroupId())) {
                isRequiredPluginPresent = true;
                break;
            }
            ++i;
        }
        return isRequiredPluginPresent;
    }

    boolean isLibraryDeclared(Artifact artifact) {
        Element runtimeElem = this.descriptor.getRootElement().getChild(RUNTIME_ELEM);
        List libraryElems = runtimeElem.getChildren(LIBRARY_ELEM);
        boolean isDependencyPresent = false;
        int i = 0;
        while (i < libraryElems.size()) {
            Element library = (Element)libraryElems.get(i);
            String libraryName = library.getAttributeValue(NAME_ATTR);
            if (libraryName != null && libraryName.indexOf(new File(artifact.getPath()).getName()) >= 0) {
                isDependencyPresent = true;
                break;
            }
            ++i;
        }
        return isDependencyPresent;
    }

    String getBundleMode() {
        String bundleMode = (String)this.context.getVariable(BUILD_MODE_PROPERTY);
        return bundleMode == null ? "" : bundleMode.trim();
    }

    String getExport(Artifact artifact) {
        String exportPattern = artifact.getDependency().getProperty(DEPENDENCY_EXPORT_PROPERTY);
        if (exportPattern == null) {
            exportPattern = (String)this.context.getVariable(DEFAULT_EXPORT_PROPERTY);
        }
        return exportPattern;
    }

    String getPackagesPrefixes(Artifact artifact) {
        String prefixes = artifact.getDependency().getProperty(DEPENDENCY_PREFIXES_PROPERTY);
        return prefixes;
    }

    void outputDescriptor() throws Exception {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setIndent(XML_INDENT);
        outputter.setExpandEmptyElements(false);
        outputter.setNewlines(true);
        String tempDir = (String)this.context.getVariable(TEMP_DIR_PROPERTY);
        FileOutputStream fos = new FileOutputStream(new File(tempDir, PLUGIN_FILENAME));
        outputter.output(this.descriptor, (OutputStream)fos);
        try {
            fos.close();
        }
        catch (IOException e) {
            log.error((Object)"Unable to close handle : plugin.xml");
        }
    }

    void setUpDescriptor() throws JDOMException, IOException {
        String descriptorDirectory = (String)this.context.getVariable(DESCRIPTOR_DIR_PROPERTY);
        File descriptorPath = new File(descriptorDirectory, PLUGIN_FILENAME).getCanonicalFile();
        log.debug((Object)descriptorPath);
        this.descriptor = new SAXBuilder().build(descriptorPath);
        this.validateDescriptor();
        this.bundledLibraryDir = (String)this.context.getVariable(BUNDLE_LIB_DIR);
    }

    void validateDescriptor() {
    }

    public Project getPom() {
        return this.pom;
    }

    public void setPom(Project pom) throws MissingAttributeException {
        this.checkAttribute(pom, "pom");
        this.pom = pom;
    }

    Document getDescriptor() {
        return this.descriptor;
    }
}

