/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags.eclipse;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.jelly.JellyContext;
import org.apache.maven.project.Dependency;
import org.apache.maven.repository.Artifact;
import org.apache.maven.repository.DefaultArtifactFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.mevenide.tags.InvalidDirectoryException;
import org.mevenide.tags.eclipse.UpdatePluginLibsTag;

public class UpdatePluginLibsTagTest
extends TestCase {
    private UpdatePluginLibsTag tag = null;
    private Artifact artifact;
    private Document doc = null;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        this.setupTag();
        this.setupArtifact();
        this.setupDoc();
    }

    private void setupTag() throws Exception {
        this.tag = new UpdatePluginLibsTag();
        MockJellyContext context = new MockJellyContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "full-descriptor").getAbsolutePath());
        this.tag.setContext(context);
    }

    private void setupArtifact() {
        Dependency d = new Dependency();
        d.setGroupId("theGroup");
        d.setArtifactId("theArtifact");
        d.setVersion("theVersion");
        this.artifact = DefaultArtifactFactory.createArtifact((Dependency)d);
    }

    private void setupDoc() {
        this.doc = new Document();
        Element root = new Element("plugin");
        root.setAttribute("version", "1.0.0");
        root.setAttribute("id", "org.mevenide.test");
        root.setAttribute("name", "Mevenide Unit Tests");
        this.doc.setRootElement(root);
    }

    protected void tearDown() throws Exception {
        this.tag = null;
    }

    public void testSetUpDescriptor() throws Exception {
        this.tag.setUpDescriptor();
        Element root = this.tag.getDescriptor().getRootElement();
        Assert.assertEquals((int)2, (int)root.getChildren().size());
        Assert.assertEquals((String)"plugin", (String)root.getName());
        Assert.assertEquals((String)"1.0.0", (String)root.getAttributeValue("version"));
        Assert.assertEquals((String)"Mevenide Unit Tests", (String)root.getAttributeValue("name"));
        Assert.assertEquals((String)"org.mevenide.test", (String)root.getAttributeValue("id"));
    }

    public void testGetBundleMode() {
        ((MockJellyContext)this.tag.getContext()).addExpectedVariable("maven.eclipse.plugin.build.mode", null);
        Assert.assertEquals((String)"", (String)this.tag.getBundleMode());
        ((MockJellyContext)this.tag.getContext()).addExpectedVariable("maven.eclipse.plugin.build.mode", "");
        Assert.assertEquals((String)"", (String)this.tag.getBundleMode());
        ((MockJellyContext)this.tag.getContext()).addExpectedVariable("maven.eclipse.plugin.build.mode", "bundle");
        Assert.assertEquals((String)"bundle", (String)this.tag.getBundleMode());
        ((MockJellyContext)this.tag.getContext()).addExpectedVariable("maven.eclipse.plugin.build.mode", "bundle  ");
        Assert.assertEquals((String)"bundle", (String)this.tag.getBundleMode());
    }

    public void testGetPluginName() {
        Assert.assertEquals((String)"theGroup", (String)this.tag.getPluginName(this.artifact));
    }

    public void testAssertRuntimePresent() throws Exception {
        this.tag.setUpDescriptor();
        this.tag.assertRuntimePresent();
        Assert.assertTrue((this.tag.getDescriptor().getRootElement().getChild("runtime") != null ? 1 : 0) != 0);
        MockJellyContext context = new MockJellyContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "empty-descriptor").getAbsolutePath());
        this.tag.setContext(context);
        this.tag.setUpDescriptor();
        this.tag.assertRuntimePresent();
        Assert.assertTrue((this.tag.getDescriptor().getRootElement().getChild("runtime") != null ? 1 : 0) != 0);
    }

    public void testAssertRequiresPresent() throws Exception {
        this.tag.setUpDescriptor();
        this.tag.assertRequiresPresent();
        Assert.assertTrue((this.tag.getDescriptor().getRootElement().getChild("requires") != null ? 1 : 0) != 0);
        MockJellyContext context = new MockJellyContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "empty-descriptor").getAbsolutePath());
        this.tag.setContext(context);
        this.tag.setUpDescriptor();
        this.tag.assertRequiresPresent();
        Assert.assertTrue((this.tag.getDescriptor().getRootElement().getChild("requires") != null ? 1 : 0) != 0);
    }

    public void testIsRequiredPluginDeclared() throws Exception {
        this.tag.setUpDescriptor();
        Assert.assertFalse((boolean)this.tag.isRequiredPluginDeclared(this.artifact));
        this.artifact.getDependency().setGroupId("org.mevenide.test");
        Assert.assertTrue((boolean)this.tag.isRequiredPluginDeclared(this.artifact));
    }

    public void testIsLibraryDeclared() throws Exception {
        this.tag.setUpDescriptor();
        Assert.assertFalse((boolean)this.tag.isLibraryDeclared(this.artifact));
        this.artifact.getDependency().setArtifactId("myDep");
        this.artifact.getDependency().setVersion("1.0");
        Assert.assertTrue((boolean)this.tag.isLibraryDeclared(this.artifact));
    }

    public void testAddRequiresPlugin() throws Exception {
        this.tag.setUpDescriptor();
        Assert.assertFalse((boolean)this.tag.isRequiredPluginDeclared(this.artifact));
        this.artifact.getDependency().setGroupId("org.mevenide.test");
        this.tag.addRequiresPlugin(this.artifact);
        Assert.assertTrue((boolean)this.tag.isRequiredPluginDeclared(this.artifact));
        int previousChildrenLength = this.tag.getDescriptor().getRootElement().getChild("requires").getChildren().size();
        this.tag.addRequiresPlugin(this.artifact);
        Assert.assertEquals((int)(previousChildrenLength + 1), (int)this.tag.getDescriptor().getRootElement().getChild("requires").getChildren().size());
    }

    public void testAddRuntimeLibrary() throws Exception {
        this.tag.setUpDescriptor();
        Assert.assertFalse((boolean)this.tag.isLibraryDeclared(this.artifact));
        this.artifact.getDependency().setArtifactId("myDep");
        this.artifact.getDependency().setVersion("1.0");
        this.tag.addRuntimeLibrary(this.artifact);
        Assert.assertTrue((boolean)this.tag.isLibraryDeclared(this.artifact));
        int previousChildrenLength = this.tag.getDescriptor().getRootElement().getChild("runtime").getChildren().size();
        this.tag.addRequiresPlugin(this.artifact);
        Assert.assertEquals((int)previousChildrenLength, (int)this.tag.getDescriptor().getRootElement().getChild("runtime").getChildren().size());
    }

    public void testUpdateRuntime() throws Exception {
        MockUpdatePluginLibsTag mockTag = new MockUpdatePluginLibsTag();
        mockTag.setExpectedAddRuntimeLibraryCalls(1);
        MockJellyContext context = new MockJellyContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "full-descriptor").getAbsolutePath());
        context.addExpectedVariable("maven.eclipse.plugin.bundle.lib.dir", "lib");
        mockTag.setContext(context);
        mockTag.setUpDescriptor();
        mockTag.updateRuntime(this.artifact);
        mockTag.verify();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.bundle.lib.dir", clazz2.getResource("/").getFile());
        mockTag.setContext(context);
        mockTag.setUpDescriptor();
        try {
            mockTag.updateRuntime(this.artifact);
            Assert.fail((String)"Expected InvalidDirectory Exception : bundled libraries dir is expected to be a subdirectory of ${basedir} (created if non existent)");
        }
        catch (InvalidDirectoryException invalidDirectoryException) {
            // empty catch block
        }
    }

    public void testUpdateRequires() throws Exception {
        MockUpdatePluginLibsTag mockTag = new MockUpdatePluginLibsTag();
        mockTag.setExpectedAddRequiresPluginCalls(1);
        MockJellyContext context = new MockJellyContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "full-descriptor").getAbsolutePath());
        mockTag.setContext(context);
        mockTag.setUpDescriptor();
        mockTag.updateRequires(this.artifact);
        mockTag.verify();
    }

    public void testUpdateDescriptor() throws Exception {
        this.artifact.getDependency().resolvedProperties().put("eclipse.plugin.bundle", "true");
        MockUpdatePluginLibsTag mockTag = new MockUpdatePluginLibsTag();
        mockTag.setExpectedAddRequiresPluginCalls(1);
        MockJellyContext context = new MockJellyContext();
        context.addExpectedVariable("maven.eclipse.plugin.build.mode", "dist");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz.getResource("/").getFile(), "full-descriptor").getAbsolutePath());
        mockTag.setContext(context);
        mockTag.setUpDescriptor();
        mockTag.updateDescriptor(this.artifact);
        mockTag.verify();
        mockTag = new MockUpdatePluginLibsTag();
        context = new MockJellyContext();
        mockTag.setExpectedAddRuntimeLibraryCalls(1);
        context.addExpectedVariable("maven.eclipse.plugin.build.mode", "bundle");
        context.addExpectedVariable("maven.eclipse.plugin.bundle.lib.dir", "lib");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.mevenide.tags.eclipse.UpdatePluginLibsTagTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.addExpectedVariable("maven.eclipse.plugin.src.dir", new File(clazz2.getResource("/").getFile(), "full-descriptor").getAbsolutePath());
        mockTag.setContext(context);
        mockTag.setUpDescriptor();
        mockTag.updateDescriptor(this.artifact);
        mockTag.verify();
    }

    public void testShouldExport() {
    }

    public void testGetPackagesPrefixes() {
    }

    public void testOutputDescriptor() {
    }

    public void testValidateDescriptor() {
    }

    private static class MockJellyContext
    extends JellyContext {
        private Map variables = new HashMap();

        public void addExpectedVariable(String key, Object value) {
            this.variables.put(key, value);
        }

        public Object findVariable(String strg) {
            return this.variables.get(strg);
        }

        public Object getVariable(String strg) {
            return this.findVariable(strg);
        }

        public void removeVariable(String strg) {
            this.variables.remove(strg);
        }
    }

    private static class MockUpdatePluginLibsTag
    extends UpdatePluginLibsTag {
        private int addRuntimeLibraryCalls = 0;
        private int expectedAddRuntimeLibraryCalls = 0;
        private int addRequiresPluginCalls = 0;
        private int expectedAddRequiresPluginCalls = 0;

        MockUpdatePluginLibsTag() {
        }

        void setExpectedAddRuntimeLibraryCalls(int ncalls) {
            this.expectedAddRuntimeLibraryCalls = ncalls;
        }

        void addRuntimeLibrary(Artifact artifact) {
            ++this.addRuntimeLibraryCalls;
        }

        void setExpectedAddRequiresPluginCalls(int ncalls) {
            this.expectedAddRequiresPluginCalls = ncalls;
        }

        void addRequiresPlugin(Artifact artifact) {
            ++this.addRequiresPluginCalls;
        }

        void verify() {
            Assert.assertEquals((int)this.expectedAddRuntimeLibraryCalls, (int)this.addRuntimeLibraryCalls);
            Assert.assertEquals((int)this.expectedAddRequiresPluginCalls, (int)this.addRequiresPluginCalls);
        }
    }
}

