/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.mevenide.tags.AbstractMevenideTag;

public class AdaptVersionTag
extends AbstractMevenideTag {
    private String version;
    private String var;

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.version, "version");
        this.checkAttribute(this.var, "var");
        String newVersion = this.adapt();
        this.context.setVariable(this.var, (Object)newVersion);
    }

    public String adapt() {
        String validValues = "0123456789.";
        String newVersion = "";
        char lastConcatenatedChar = '-';
        for (int i = 0; i < this.version.length(); ++i) {
            if (validValues.indexOf(this.version.charAt(i)) < 0) continue;
            if (Character.isDigit(lastConcatenatedChar)) {
                if (Character.isDigit(this.version.charAt(i))) {
                    newVersion = newVersion + ".";
                }
                lastConcatenatedChar = this.version.charAt(i);
                newVersion = newVersion + lastConcatenatedChar;
                continue;
            }
            if (!Character.isDigit(this.version.charAt(i))) continue;
            lastConcatenatedChar = this.version.charAt(i);
            newVersion = newVersion + lastConcatenatedChar;
        }
        if (newVersion.endsWith(".")) {
            newVersion = newVersion.substring(0, newVersion.length() - 1);
        }
        if (newVersion.trim().equals("")) {
            newVersion = "0.0.1";
        } else if (this.version.equals("SNAPSHOT") || this.version.indexOf("SNAPSHOT") >= 0) {
            // empty if block
        }
        for (int digitNumber = this.countNumbers(newVersion); digitNumber < 3; ++digitNumber) {
            newVersion = newVersion + ".0";
        }
        return newVersion;
    }

    private int countNumbers(String version) {
        int u = 0;
        for (int i = 0; i < version.length(); ++i) {
            if (!Character.isDigit(version.charAt(i))) continue;
            ++u;
        }
        return u;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

