/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.mevenide.tags.AbstractMevenideTag;

public class FindLicenseTag
extends AbstractMevenideTag {
    private String var;
    private File jarFile;
    private static final String[] possibleLocations = new String[]{"META-INF/LICENSE", "LICENSE", "COPYING"};

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        this.checkAttribute(this.jarFile, "jarFile");
        this.checkAttribute(this.var, "var");
        String foundLicense = this.readLicense();
        this.context.setVariable(this.var, (Object)foundLicense);
    }

    public String readLicense() throws JellyTagException {
        StringBuffer toReturn = new StringBuffer();
        JarFile jar = null;
        try {
            jar = new JarFile(this.jarFile);
            Enumeration<JarEntry> en = jar.entries();
            JarEntry found = null;
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (entry.isDirectory() || !this.checkName(entry.getName())) continue;
                found = entry;
                break;
            }
            if (found != null) {
                InputStream stream = jar.getInputStream(found);
                BufferedReader read = new BufferedReader(new InputStreamReader(stream));
                char[] chr = new char[1];
                int rd = read.read(chr);
                while (rd != -1) {
                    toReturn.append(chr);
                    rd = read.read(chr);
                }
                read.close();
            }
        }
        catch (Exception exc) {
            throw new JellyTagException((Throwable)exc);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException io) {
                    throw new JellyTagException((Throwable)io);
                }
            }
        }
        if (toReturn.length() == 0) {
            return null;
        }
        return toReturn.toString();
    }

    private boolean checkName(String path) {
        String upperCase = path.toUpperCase();
        for (int i = 0; i < possibleLocations.length; ++i) {
            if (!upperCase.startsWith(possibleLocations[i])) continue;
            return true;
        }
        return false;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }
}

