/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags.jbuilder.opentool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.jdom.JDOMException;
import org.mevenide.tags.AbstractMevenideTag;

public class GenerateConfig
extends AbstractMevenideTag {
    private static final Log log = LogFactory.getLog((Class)(class$org$mevenide$tags$jbuilder$opentool$GenerateConfig == null ? (class$org$mevenide$tags$jbuilder$opentool$GenerateConfig = GenerateConfig.class$("org.mevenide.tags.jbuilder.opentool.GenerateConfig")) : class$org$mevenide$tags$jbuilder$opentool$GenerateConfig));
    private static final String MAVEN_REPOSITORYLOCAL_PROPERTY = "maven.repo.local";
    private static final String DESCRIPTOR_DIR_PROPERTY = "maven.opentool.config.dir";
    private static final String CONFIG_FILENAME_PROPERTY = "maven.opentool.config.filename";
    private Project pom;
    private FileOutputStream configFile;
    private boolean useLocalRepository = false;
    private String dependencyLocation = "";
    private boolean withThisArtifact = true;
    static /* synthetic */ Class class$org$mevenide$tags$jbuilder$opentool$GenerateConfig;

    public void doTag(XMLOutput arg0) throws MissingAttributeException, JellyTagException {
        try {
            this.setUpDescriptor();
            List artifacts = this.pom.getArtifacts();
            PrintWriter out = new PrintWriter(this.configFile);
            if (artifacts != null) {
                for (int i = 0; i < artifacts.size(); ++i) {
                    Artifact artifact = (Artifact)artifacts.get(i);
                    if (!"true".equals(artifact.getDependency().getProperty("jbuilder.opentool.bundle"))) continue;
                    if (this.useLocalRepository) {
                        out.println("addpath " + artifact.getPath());
                        continue;
                    }
                    out.println("addpath " + this.dependencyLocation + artifact.getName());
                }
            }
            if (this.isWithThisArtifact()) {
                if (this.useLocalRepository) {
                    String localRepo = (String)this.context.getVariable(MAVEN_REPOSITORYLOCAL_PROPERTY);
                    out.println("addpath " + localRepo + "/" + this.pom.getGroupId() + "/jars/" + this.pom.getArtifactId() + "-" + this.pom.getCurrentVersion() + ".jar");
                } else {
                    out.println("addpath " + this.dependencyLocation + this.pom.getArtifactId() + "-" + this.pom.getCurrentVersion() + ".jar");
                }
            }
            out.flush();
            out.close();
            this.configFile.close();
        }
        catch (Exception exc) {
            throw new JellyTagException((Throwable)exc);
        }
    }

    void setUpDescriptor() throws JDOMException, IOException {
        String descriptorDirectory = (String)this.context.getVariable(DESCRIPTOR_DIR_PROPERTY);
        File descriptorDirFile = new File(descriptorDirectory);
        descriptorDirFile.mkdirs();
        String configFileName = (String)this.context.getVariable(CONFIG_FILENAME_PROPERTY);
        File descriptorPath = new File(descriptorDirectory, configFileName).getCanonicalFile();
        log.debug((Object)descriptorPath);
        this.configFile = new FileOutputStream(descriptorPath);
    }

    public Project getPom() {
        return this.pom;
    }

    public void setPom(Project pom) throws MissingAttributeException {
        this.checkAttribute(pom, "pom");
        this.pom = pom;
    }

    public void setUseLocalRepository(boolean useLocalRepository) {
        this.useLocalRepository = useLocalRepository;
    }

    public boolean isUseLocalRepository() {
        return this.useLocalRepository;
    }

    public void setDependencyLocation(String dependencyLocation) {
        this.dependencyLocation = dependencyLocation;
    }

    public String getDependencyLocation() {
        return this.dependencyLocation;
    }

    public void setWithThisArtifact(boolean withThisArtifact) {
        this.withThisArtifact = withThisArtifact;
    }

    public boolean isWithThisArtifact() {
        return this.withThisArtifact;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

