/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import [Ljava.lang.String;;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.mevenide.netbeans.cargo.RegistryEvent;
import org.mevenide.netbeans.cargo.RegistryListener;
import org.mevenide.netbeans.cargo.ViewLogAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.lookup.Lookups;

final class RunningServerNode
extends AbstractNode
implements RegistryListener {
    private Container container;
    private State lastState;
    private Sheet.Set basicProps;
    private Sheet.Set configProps;
    private Action viewLog;

    RunningServerNode(Container cont) {
        super((Children)new ServChildren(cont), Lookups.fixed((Object[])new Object[]{cont}));
        this.container = cont;
        this.setName(this.container.getName());
        String port = this.container.getConfiguration().getPropertyValue("cargo.servlet.port");
        this.setDisplayName(this.getName() + " at port " + port);
        this.updateName(this.container.getState());
        CargoServerRegistry.getInstance().addRegistryListener(this);
        this.viewLog = new ViewLogAction(this.container.getOutput(), "View Log", "Log " + this.getName());
    }

    public boolean canCopy() {
        return false;
    }

    public void containerAdded(RegistryEvent event) {
    }

    public void containerRemoved(RegistryEvent event) {
    }

    public void stateChanged(RegistryEvent event) {
        if (event.getContainer() == this.container) {
            this.lastState = event.getFutureState() != null ? event.getFutureState() : this.container.getState();
            this.updateName(this.lastState);
            this.firePropertyChange(null, null, null);
        }
    }

    public void containerDeployablesChanged(RegistryEvent event) {
    }

    private void updateName(State state) {
        String port = this.container.getConfiguration().getPropertyValue("cargo.servlet.port");
        if (state == State.STARTED) {
            this.setShortDescription(this.getName() + " started at " + this.container.getHomeDir());
        } else if (state == State.STARTING) {
            this.setShortDescription(this.getName() + " starting at " + this.container.getHomeDir());
        } else if (state == State.STOPPING) {
            this.setShortDescription(this.getName() + " stopping at " + this.container.getHomeDir());
        } else {
            this.setShortDescription(this.getName() + " at " + this.container.getHomeDir());
        }
        this.fireDisplayNameChange(null, this.getDisplayName());
    }

    public void destroy() throws IOException {
        super.destroy();
        CargoServerRegistry.getInstance().removeRegistryListener(this);
    }

    public String getHtmlDisplayName() {
        String partial = null;
        if (this.lastState == State.STARTED) {
            partial = "<b>" + this.getName() + "</b>";
        }
        if (this.lastState == State.STARTING) {
            partial = "<b><i>" + this.getName() + "</i></b>";
        }
        if (this.lastState == State.STOPPING) {
            partial = "<i>" + this.getName() + "</i>";
        }
        if (partial != null) {
            String port = this.container.getConfiguration().getPropertyValue("cargo.servlet.port");
            return "<html>" + partial + " at port " + port + "</html>";
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean context) {
        Action[] retValue = new Action[]{new StartStop(), null, new Remove(), null, this.viewLog, null, ((PropertiesAction)PropertiesAction.get((Class)PropertiesAction.class)).createContextAwareInstance(Lookups.singleton((Object)this))};
        return retValue;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        this.basicProps = sheet.get("properties");
        try {
            ContainerReflection home = new ContainerReflection(this.container, File.class, "homeDir");
            home.setName("home");
            home.setDisplayName("Home Directory");
            home.setShortDescription("The directory where the container is installed.");
            ContainerReflection id = new ContainerReflection(this.container, String.class, "getId", null);
            id.setName("id");
            id.setDisplayName("Container Type ID");
            ContainerReflection name = new ContainerReflection(this.container, String.class, "getName", null);
            name.setName("name");
            name.setDisplayName("Container Type Name");
            ContainerReflection timeout = new ContainerReflection(this.container, Long.TYPE, "timeout");
            timeout.setDisplayName("Timeout");
            timeout.setShortDescription("Timeout (in ms) after which we consider the container cannot be started or stopped.");
            timeout.setName("timeout");
            ContainerReflection war = new ContainerReflection(this.container.getCapability(), Boolean.TYPE, "supportsWar", null);
            war.setDisplayName("Support WARs");
            war.setName("war");
            ContainerReflection ear = new ContainerReflection(this.container.getCapability(), Boolean.TYPE, "supportsEar", null);
            ear.setDisplayName("Support EARs");
            ear.setName("ear");
            ContainerReflection output = new ContainerReflection(this.container, File.class, "getOutput", "setOutput");
            output.setDisplayName("Output File");
            output.setShortDescription("The file to which the container's output will be logged to");
            output.setName("output");
            ContainerReflection append = new ContainerReflection(this.container, Boolean.TYPE, "isAppend", "setAppend");
            append.setDisplayName("Append to Output File");
            append.setShortDescription("Sets whether output of the container should be appended to an existing file, or the existing file should be truncated.");
            append.setName("append");
            ContainerReflection classpath = new ContainerReflection(this.container, String;.class, "extraClasspath");
            classpath.setDisplayName("Extra Classpath");
            classpath.setShortDescription("Additional Container Classpath.");
            classpath.setName("classpath");
            this.basicProps.put(new Node.Property[]{id, name, war, ear, home, output, append, timeout, classpath});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        this.configProps = new Sheet.Set();
        this.configProps.setName("configuration");
        this.configProps.setDisplayName("Configuration");
        try {
            Configuration config = this.container.getConfiguration();
            ContainerReflection dir = new ContainerReflection(config, File.class, "getDir", null);
            dir.setName("dir");
            dir.setDisplayName("Directory");
            dir.setShortDescription("Configuration Directory");
            Map map = config.getProperties();
            Iterator it = map.entrySet().iterator();
            Node.Property[] prps = new Node.Property[map.entrySet().size() + 1];
            prps[0] = dir;
            int index = 1;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                prps[index] = new ConfigProperty((String)entry.getKey());
                ++index;
            }
            this.configProps.put(prps);
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        sheet.put(this.configProps);
        return sheet;
    }

    private static final class ServChildren
    extends Children.Keys
    implements RegistryListener {
        private Container container;

        public ServChildren(Container cont) {
            this.container = cont;
        }

        private void updateKeys() {
            Collection col = CargoServerRegistry.getInstance().getDeployables(this.container);
            this.setKeys(col);
        }

        protected void addNotify() {
            super.addNotify();
            this.updateKeys();
            CargoServerRegistry.getInstance().addRegistryListener(this);
        }

        protected void removeNotify() {
            CargoServerRegistry.getInstance().removeRegistryListener(this);
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Deployable dep = (Deployable)key;
            AbstractNode n = new AbstractNode(Children.LEAF);
            if (dep instanceof WAR) {
                n.setName(((WAR)dep).getContext());
                n.setShortDescription("WAR Context: " + n.getName());
            }
            return new Node[]{n};
        }

        public void containerAdded(RegistryEvent event) {
        }

        public void containerRemoved(RegistryEvent event) {
        }

        public void stateChanged(RegistryEvent event) {
        }

        public void containerDeployablesChanged(RegistryEvent event) {
            this.updateKeys();
        }
    }

    private class ConfigProperty
    extends PropertySupport {
        private String key;

        ConfigProperty(String propkey) {
            super(propkey, class$java$lang$String == null ? (class$java$lang$String = RunningServerNode.class$("java.lang.String")) : class$java$lang$String, propkey, propkey, true, true);
            this.key = propkey;
        }

        public void setValue(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            RunningServerNode.this.container.getConfiguration().setProperty(this.key, (String)obj);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return RunningServerNode.this.container.getConfiguration().getPropertyValue(this.key);
        }

        public boolean canWrite() {
            if (RunningServerNode.this.container.getState() == State.STOPPED) {
                return super.canWrite();
            }
            return false;
        }
    }

    private class ContainerReflection
    extends PropertySupport.Reflection {
        ContainerReflection(Object inst, Class clazz, String prop) throws NoSuchMethodException {
            super(inst, clazz, prop);
        }

        ContainerReflection(Object inst, Class clazz, String getter, String setter) throws NoSuchMethodException {
            super(inst, clazz, getter, setter);
        }

        public boolean canWrite() {
            if (RunningServerNode.this.container.getState() == State.STOPPED) {
                return super.canWrite();
            }
            return false;
        }
    }

    private class Remove
    extends AbstractAction {
        public Remove() {
            this.putValue("Name", "Remove");
            this.putValue("ShortDescription", "Remove Cargo Container");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CargoServerRegistry.getInstance().removeContainer(RunningServerNode.this.container);
        }
    }

    private class StartStop
    extends AbstractAction {
        public StartStop() {
            this.putValue("Name", "Start/Stop Container");
            this.putValue("ShortDescription", "Start/Stop Cargo Container");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RunningServerNode.this.container.getState() == State.STOPPED) {
                CargoServerRegistry.getInstance().startContainer(RunningServerNode.this.container);
            } else if (RunningServerNode.this.container.getState() == State.STARTED) {
                CargoServerRegistry.getInstance().stopContainer(RunningServerNode.this.container);
            }
        }
    }
}

