/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.codehaus.cargo.container.Container;
import org.mevenide.netbeans.cargo.CargoServerRegistry;

public class ContainerPanel
extends JPanel {
    private JButton btnInstallDir;
    private JCheckBox cbStart;
    private JComboBox comType;
    private JLabel lblInstallDir;
    private JLabel lblPort;
    private JLabel lblType;
    private JTextField txtInstallDir;
    private JTextField txtPort;

    public ContainerPanel() {
        this.initComponents();
        this.comType.setModel(new DefaultComboBoxModel<String>(CargoServerRegistry.CONTAINER_TYPES));
        this.setPreferredSize(new Dimension(500, 150));
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.comType = new JComboBox();
        this.lblInstallDir = new JLabel();
        this.txtInstallDir = new JTextField();
        this.btnInstallDir = new JButton();
        this.cbStart = new JCheckBox();
        this.lblPort = new JLabel();
        this.txtPort = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblType.setText("Container Type");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comType, gridBagConstraints);
        this.lblInstallDir.setText("Install Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblInstallDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtInstallDir, gridBagConstraints);
        this.btnInstallDir.setText("Browse...");
        this.btnInstallDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContainerPanel.this.btnInstallDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 6, 0, 6);
        this.add((Component)this.btnInstallDir, gridBagConstraints);
        this.cbStart.setText("Start Immediately");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.cbStart, gridBagConstraints);
        this.lblPort.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblPort, gridBagConstraints);
        this.txtPort.setText("8080");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtPort, gridBagConstraints);
    }

    private void btnInstallDirActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Container's Home Directory");
        chooser.setFileSelectionMode(1);
        String path = this.txtInstallDir.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.txtInstallDir.setText(projectDir.getAbsolutePath());
        }
    }

    public void createContainer() {
        CargoServerRegistry reg = CargoServerRegistry.getInstance();
        Container cont = reg.getFactory().createContainer((String)this.comType.getSelectedItem());
        File homeDir = new File(this.txtInstallDir.getText());
        if (homeDir.exists()) {
            cont.setHomeDir(homeDir);
            try {
                cont.setOutput(File.createTempFile(cont.getId(), "log"));
            }
            catch (IOException exc) {
                // empty catch block
            }
            cont.setConfiguration(reg.getConfigFactory().createConfiguration(cont, "standalone"));
            cont.getConfiguration().setProperty("cargo.servlet.port", this.txtPort.getText());
            CargoServerRegistry.getInstance().addContainer(cont);
            if (this.cbStart.isSelected()) {
                reg.startContainer(cont);
            }
        } else {
            throw new IllegalArgumentException("TODO");
        }
    }
}

