/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.cargo;

import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import org.codehaus.cargo.container.Container;
import org.mevenide.netbeans.cargo.AddContainerAction;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.mevenide.netbeans.cargo.RegistryEvent;
import org.mevenide.netbeans.cargo.RegistryListener;
import org.mevenide.netbeans.cargo.RunningServerNode;
import org.mevenide.netbeans.cargo.ViewLogAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public final class ServersNode
extends AbstractNode {
    private static Node processNode;

    private ServersNode() {
        super((Children)new ServChildren());
        this.setName("Cargo Containers");
        this.setShortDescription("Cargo Containers");
    }

    public static Node getRootNode() {
        if (processNode == null) {
            processNode = new ServersNode();
        }
        return processNode;
    }

    public Action[] getActions(boolean context) {
        Action[] retValue = new Action[]{new AddContainerAction(), new ViewLogAction(CargoServerRegistry.getInstance().getMonitorFile(), "View Cargo Log", "Cargo Monitor")};
        return retValue;
    }

    private static final class ServChildren
    extends Children.Keys
    implements RegistryListener {
        private static final Object KEY_NONE = "NONE";

        private void updateKeys() {
            Set<Object> c = CargoServerRegistry.getInstance().getContainers();
            this.setKeys(c.isEmpty() ? Collections.singleton(KEY_NONE) : c);
        }

        protected void addNotify() {
            super.addNotify();
            this.updateKeys();
            CargoServerRegistry.getInstance().addRegistryListener(this);
        }

        protected void removeNotify() {
            CargoServerRegistry.getInstance().removeRegistryListener(this);
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key == KEY_NONE) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName("No Containers Installed");
                n.setShortDescription("Please add a cargo container");
                return new Node[]{n};
            }
            return new Node[]{new RunningServerNode((Container)key)};
        }

        public void containerAdded(RegistryEvent event) {
            this.updateKeys();
        }

        public void containerRemoved(RegistryEvent event) {
            this.updateKeys();
        }

        public void stateChanged(RegistryEvent event) {
        }

        public void containerDeployablesChanged(RegistryEvent event) {
        }
    }

    static final class RootHandle
    implements Node.Handle {
        static final long serialVersionUID = -6979883764640743928L;

        RootHandle() {
        }

        public Node getNode() {
            return ServersNode.getRootNode();
        }
    }
}

