/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee;

import java.io.File;
import java.io.IOException;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenEjbJarImpl
implements EjbJarImplementation {
    private MavenProject project;

    public MavenEjbJarImpl(MavenProject proj) {
        this.project = proj;
    }

    public FileObject getDeploymentDescriptor() {
        File fl = MavenEjbJarImpl.guessEjbJarDescriptor(this.project);
        if (fl != null) {
            return FileUtil.toFileObject((File)fl);
        }
        return null;
    }

    public String getJ2eePlatformVersion() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                EjbJar ejb = prov.getDDRoot(dd);
                String ejbVersion = ejb.getVersion().toString();
                return ejbVersion;
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        return "2.0";
    }

    public FileObject getMetaInf() {
        FileObject toRet;
        FileObject fo = FileUtilities.getFileObjectForProperty((String)"maven.ejb.src", (IPropertyResolver)this.project.getPropertyResolver());
        if (fo != null && (toRet = fo.getFileObject("META-INF")) != null) {
            return toRet;
        }
        Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
        SourceGroup[] grps = srcs.getSourceGroups("Resources");
        if (grps != null) {
            for (int i = 0; i < grps.length; ++i) {
                fo = grps[0].getRootFolder().getFileObject("META-INF");
                if (fo == null) continue;
                return fo;
            }
        }
        return null;
    }

    public static File guessEjbJarDescriptor(MavenProject project) {
        File toRet;
        File fo = FileUtilities.getFileForProperty((String)"maven.ejb.src", (IPropertyResolver)project.getPropertyResolver());
        if (fo != null && fo.exists() && (toRet = new File(fo, "META-INF/ejb-jar.xml")).exists()) {
            return toRet;
        }
        Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] grps = srcs.getSourceGroups("Resources");
        if (grps != null) {
            for (int i = 0; i < grps.length; ++i) {
                fo = FileUtil.toFile((FileObject)grps[0].getRootFolder());
                File toRet2 = new File(fo, "META-INF/ejb-jar.xml");
                if (!toRet2.exists()) continue;
                return toRet2;
            }
        }
        fo = FileUtilities.getFileForProperty((String)"maven.ejb.src", (IPropertyResolver)project.getPropertyResolver());
        return new File(fo, "META-INF/ejb-jar.xml");
    }

    public FileObject[] getJavaSources() {
        Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        FileObject[] toRet = null;
        if (grps != null) {
            toRet = new FileObject[grps.length];
            for (int i = 0; i < grps.length; ++i) {
                toRet[i] = grps[i].getRootFolder();
            }
        }
        return toRet;
    }

    public boolean isValid() {
        return this.getDeploymentDescriptor() != null;
    }
}

