/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.deploy;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.j2ee.deploy.NbDeployPanel;
import org.mevenide.netbeans.j2ee.web.WebModuleImpl;
import org.mevenide.netbeans.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class NbDeployAction
extends AbstractAction
implements Deployment.Logger,
Runnable {
    private MavenProject project;
    private InputOutput io;
    private String serverInstanceid;
    private String path;
    private boolean debug;

    public NbDeployAction(MavenProject prj) {
        this.putValue("Name", "Netbeans Deploy");
        this.project = prj;
    }

    public void actionPerformed(ActionEvent event) {
        J2eeModuleProvider prov = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        NbDeployPanel panel = new NbDeployPanel(prov);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "Deploy Web Application.");
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            this.serverInstanceid = panel.getSelectedServer();
            this.path = panel.getPath();
            this.debug = panel.isDebugging();
            prov.setServerInstanceID(this.serverInstanceid);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.io = IOProvider.getDefault().getIO(this.project.getName(), true);
        this.io.select();
        try {
            J2eeModuleProvider jmp = null;
            jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            WebModuleImpl impl = ((WebModuleProviderImpl)this.project.getLookup().lookup(WebModuleProviderImpl.class)).getWebImpl();
            if (impl != null && impl.isValid()) {
                jmp.getConfigSupport().setWebContextRoot(impl.getContextPath());
            }
            jmp.getConfigSupport().ensureConfigurationReady();
            String clientUrl = Deployment.getDefault().deploy(jmp, this.debug, impl == null ? "" : impl.getContextPath(), this.path, true, (Deployment.Logger)this);
            URL url = new URL(clientUrl);
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            if (this.debug) {
                // empty if block
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().log("e message=" + e.getMessage());
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            this.io.getOut().close();
        }
    }

    public void log(String str) {
        this.io.getOut().println(str);
    }
}

