/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.deploy;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.ErrorManager;

public class NbDeployPanel
extends JPanel {
    private J2eeModuleProvider provider;
    private JButton btnPage;
    private JCheckBox cbDebug;
    private JComboBox comServer;
    private JLabel lblPage;
    private JLabel lblServer;
    private JTextField txtPage;

    public NbDeployPanel(J2eeModuleProvider prov) {
        this.initComponents();
        this.cbDebug.setVisible(false);
        this.provider = prov;
        this.loadModel(this.provider.getServerInstanceID());
        J2eeModule module = this.provider.getJ2eeModule();
        if (!J2eeModule.WAR.equals(module.getModuleType())) {
            this.txtPage.setVisible(false);
            this.lblPage.setVisible(false);
            this.btnPage.setVisible(false);
        }
    }

    private void loadModel(String selectedId) {
        ErrorManager.getDefault().log(256, "selected id=" + selectedId);
        String[] ids = Deployment.getDefault().getServerInstanceIDs();
        ArrayList<Wrapper> col = new ArrayList<Wrapper>();
        Wrapper selected = null;
        for (int i = 0; i < ids.length; ++i) {
            Wrapper wr = new Wrapper(ids[i], Deployment.getDefault().getServerInstanceDisplayName(ids[i]));
            col.add(wr);
            if (!selectedId.equals(ids[i])) continue;
            selected = wr;
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
        if (selected != null) {
            ErrorManager.getDefault().log(256, " -> setting selected id=" + selectedId);
            this.comServer.setSelectedItem(selected);
        }
    }

    public String getSelectedServer() {
        return ((Wrapper)this.comServer.getSelectedItem()).getId();
    }

    public String getPath() {
        return this.txtPage.getText();
    }

    public boolean isDebugging() {
        return this.cbDebug.isSelected();
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblPage = new JLabel();
        this.txtPage = new JTextField();
        this.btnPage = new JButton();
        this.cbDebug = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.lblServer.setText("Server to Deploy :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblServer, gridBagConstraints);
        this.comServer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comServer, gridBagConstraints);
        this.lblPage.setText("Page :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.lblPage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.txtPage, gridBagConstraints);
        this.btnPage.setText("Select...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.btnPage, gridBagConstraints);
        this.cbDebug.setText("Debug");
        this.cbDebug.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.cbDebug.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.cbDebug, gridBagConstraints);
    }

    private class Wrapper {
        private String dn;
        private String id;

        public Wrapper(String serverid, String name) {
            this.id = serverid;
            this.dn = name;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.dn;
        }
    }
}

