/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.j2ee.MavenEarEjbProvider;
import org.mevenide.netbeans.j2ee.MavenEarImpl;
import org.mevenide.netbeans.j2ee.MavenEjbJarImpl;
import org.mevenide.netbeans.j2ee.web.WebModuleImpl;
import org.mevenide.netbeans.j2ee.web.WebModuleProviderImpl;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenJ2eeModule
implements J2eeModule {
    private MavenProject project;
    private String url;
    private ArrayList listeners;

    public MavenJ2eeModule(MavenProject proj) {
        this.project = proj;
        this.url = this.project.getOriginalMavenProject().getArtifactId();
        this.listeners = new ArrayList();
    }

    public void addVersionListener(J2eeModule.VersionListener listener) {
        this.listeners.add(listener);
    }

    public void removeVersionListener(J2eeModule.VersionListener listener) {
        this.listeners.remove(listener);
    }

    public FileObject getArchive() throws IOException {
        FileObject buildDir;
        FileObject fo;
        File fil;
        String val;
        if (J2eeModule.EAR.equals(this.getModuleType())) {
            boolean postEar17 = this.project.getPropertyLocator().getPropertyLocation("maven.ear.final.name") != -1;
            String string = val = postEar17 ? this.project.getPropertyResolver().resolveString("${maven.build.dir}/${maven.ear.final.name}") : this.project.getPropertyResolver().resolveString("${maven.build.dir}/${maven.final.name}.ear");
            if (val != null) {
                fil = new File(val);
                fo = FileUtil.toFileObject((File)(fil = FileUtil.normalizeFile((File)fil)));
                if (fo != null) {
                    return fo;
                }
            }
        }
        if (J2eeModule.EJB.equals(this.getModuleType())) {
            boolean postEjb16 = this.project.getPropertyLocator().getPropertyLocation("maven.ejb.build.dir") != -1;
            String string = val = postEjb16 ? this.project.getPropertyResolver().resolveString("${maven.ejb.build.dir}/${maven.ejb.final.name}") : this.project.getPropertyResolver().resolveString("${maven.build.dir}/${maven.final.name}.jar");
            if (val != null) {
                fil = new File(val);
                fo = FileUtil.toFileObject((File)(fil = FileUtil.normalizeFile((File)fil)));
                if (fo != null) {
                    return fo;
                }
            }
        }
        if (J2eeModule.WAR.equals(this.getModuleType()) && (buildDir = FileUtilities.getFileObjectForProperty((String)"maven.war.build.dir", (IPropertyResolver)this.project.getPropertyResolver())) != null) {
            FileObject arch;
            String name = this.project.getPropertyResolver().getResolvedValue("maven.war.final.name");
            if (!name.endsWith(".war")) {
                name = name + ".war";
            }
            if ((arch = buildDir.getFileObject(name)) != null) {
                return arch;
            }
        }
        System.out.println("getarchive- get type=" + this.getModuleType());
        return null;
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fo;
        if ((J2eeModule.EJB.equals(this.getModuleType()) || J2eeModule.EAR.equals(this.getModuleType())) && FileUtil.isArchiveFile((FileObject)(fo = this.getArchive()))) {
            FileObject root = FileUtil.getArchiveRoot((FileObject)fo);
            return new ContentIterator(root);
        }
        if (J2eeModule.WAR.equals(this.getModuleType())) {
            return new ContentIterator(this.getContentDirectory());
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        if (J2eeModule.WAR.equals(this.getModuleType())) {
            return FileUtilities.getFileObjectForProperty((String)"maven.war.webapp.dir", (IPropertyResolver)this.project.getPropertyResolver());
        }
        return null;
    }

    public BaseBean getDeploymentDescriptor(String location) {
        EjbJar ejb;
        EarProvider prov;
        Ear ear;
        FileObject fo;
        WebApp webApp;
        if ("WEB-INF/web.xml".equals(location) && (webApp = this.getWebApp()) != null) {
            return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getBaseBean((CommonDDBean)webApp);
        }
        if ("META-INF/application.xml".equals(location) && (fo = (ear = (prov = (EarProvider)this.project.getLookup().lookup(EarProvider.class)).findEar(this.project.getProjectDirectory())).getDeploymentDescriptor()) != null) {
            try {
                Application app = org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getDDRoot(fo);
                if (app != null) {
                    return org.netbeans.modules.j2ee.dd.api.application.DDProvider.getDefault().getBaseBean((CommonDDBean)app);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(e.getLocalizedMessage());
            }
        }
        if ("META-INF/ejb-jar.xml".equals(location) && (fo = (ejb = (prov = (EjbJarProvider)this.project.getLookup().lookup(EjbJarProvider.class)).findEjbJar(this.project.getProjectDirectory())).getDeploymentDescriptor()) != null) {
            try {
                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar e = DDProvider.getDefault().getDDRoot(fo);
                if (e != null) {
                    return DDProvider.getDefault().getBaseBean((CommonDDBean)e);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(e.getLocalizedMessage());
            }
        }
        return null;
    }

    private WebApp getWebApp() {
        try {
            WebModuleImpl impl = ((WebModuleProviderImpl)this.project.getLookup().lookup(WebModuleProviderImpl.class)).getWebImpl();
            FileObject deploymentDescriptor = impl.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    public Object getModuleType() {
        MavenEjbJarImpl ejb = ((MavenEarEjbProvider)this.project.getLookup().lookup(MavenEarEjbProvider.class)).getEjbImplementation();
        if (ejb != null && ejb.isValid()) {
            return J2eeModule.EJB;
        }
        MavenEarImpl ear = ((MavenEarEjbProvider)this.project.getLookup().lookup(MavenEarEjbProvider.class)).getEarImplementation();
        if (ear != null && ear.isValid()) {
            return J2eeModule.EAR;
        }
        File connStr = FileUtilities.getFileForProperty((String)"maven.rar.raxml", (IPropertyResolver)this.project.getPropertyResolver());
        if (connStr != null && connStr.exists()) {
            return J2eeModule.CONN;
        }
        WebModuleImpl wm = ((WebModuleProviderImpl)this.project.getLookup().lookup(WebModuleProviderImpl.class)).getWebImpl();
        if (wm != null && wm.isValid()) {
            return J2eeModule.WAR;
        }
        return null;
    }

    public String getModuleVersion() {
        WebModuleImpl wm = ((WebModuleProviderImpl)this.project.getLookup().lookup(WebModuleProviderImpl.class)).getWebImpl();
        if (wm != null && wm.isValid()) {
            return wm.getJ2eePlatformVersion();
        }
        MavenEjbJarImpl ej = ((MavenEarEjbProvider)this.project.getLookup().lookup(MavenEarEjbProvider.class)).getEjbImplementation();
        if (ej != null && ej.isValid()) {
            return ej.getJ2eePlatformVersion();
        }
        MavenEarImpl ea = ((MavenEarEjbProvider)this.project.getLookup().lookup(MavenEarEjbProvider.class)).getEarImplementation();
        if (ea != null && ea.isValid()) {
            return ea.getJ2eePlatformVersion();
        }
        return "1.4";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newurl) {
        this.url = newurl;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject rt, FileObject fo) {
            this.f = fo;
            this.root = rt;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private ArrayList ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject f = (FileObject)this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

