/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.deploy;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.mevenide.netbeans.j2ee.deploy.DeployPanel;
import org.mevenide.netbeans.j2ee.deploy.DeployerRunner;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class RedeployAction
extends AbstractAction {
    private MavenProject project;
    private DeployPanel panel;

    public RedeployAction(MavenProject proj) {
        this.putValue("Name", "Redeploy using Cargo");
        this.project = proj;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File war = this.project.getWar();
        if (war != null) {
            if (!war.exists()) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)"War file not built. Please build first.");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            } else {
                CargoServerRegistry reg = CargoServerRegistry.getInstance();
                Deployable[] depls = reg.findDeployables(war.getAbsolutePath());
                if (depls != null && depls.length > 0) {
                    for (int i = 0; i < depls.length; ++i) {
                        Container cont = reg.findContainerForDeployable(depls[i]);
                        DeployerRunner runner = new DeployerRunner(cont, (WAR)depls[i]);
                        RequestProcessor.getDefault().post((Runnable)runner);
                    }
                }
            }
        }
    }
}

