/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.mevenide.netbeans.j2ee.MavenEarImpl;
import org.mevenide.netbeans.j2ee.MavenEjbJarImpl;
import org.mevenide.netbeans.j2ee.MavenJ2eeModule;
import org.mevenide.netbeans.j2ee.web.WebModuleImpl;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2eeModuleProviderImpl
extends J2eeModuleProvider {
    public static final String SERVERID_PROPERTY = "maven.netbeans.deploy.serverid";
    private String serverId = null;
    private MavenProject project;
    private MavenJ2eeModule j2eeModule;
    private ModuleChangeReporter moduleChangeReporter;

    public J2eeModuleProviderImpl(MavenProject proj) {
        this.project = proj;
        this.j2eeModule = new MavenJ2eeModule(this.project);
        this.moduleChangeReporter = new ModuleChangeReporterImpl();
    }

    public FileObject findDeploymentConfigurationFile(String str) {
        File fil = this.getDeploymentConfigurationFile(str);
        if (fil != null && fil.exists()) {
            return FileUtil.toFileObject((File)fil);
        }
        return null;
    }

    public File getDeploymentConfigurationFile(String str) {
        File connFile;
        if ("WEB-INF/web.xml".equals(str)) {
            return WebModuleImpl.guessWebDescriptor(this.project);
        }
        if ("META-INF/ejb-jar.xml".equals(str)) {
            return MavenEjbJarImpl.guessEjbJarDescriptor(this.project);
        }
        if ("META-INF/ra.xml".equals(str) && (connFile = FileUtilities.getFileForProperty((String)"maven.rar.raxml", (IPropertyResolver)this.project.getPropertyResolver())) != null) {
            return connFile;
        }
        if (J2eeModule.EAR.equals(str)) {
            return MavenEarImpl.guessEarDescriptor(this.project);
        }
        String path = this.getConfigSupport().getContentRelativePath(str);
        if (J2eeModule.WAR.equals(this.j2eeModule.getModuleType())) {
            File buildDir = FileUtilities.getFileForProperty((String)"maven.war.webapp.dir", (IPropertyResolver)this.project.getPropertyResolver());
            File fil = new File(buildDir, path);
            return fil;
        }
        File buildDir = FileUtilities.getFileForProperty((String)"maven.build.dir", (IPropertyResolver)this.project.getPropertyResolver());
        File fil = new File(buildDir, path);
        System.out.println("Now how to lookup this file " + path + " for j2eeType=" + this.j2eeModule.getModuleType());
        return fil;
    }

    public J2eeModule getJ2eeModule() {
        if (this.j2eeModule.getModuleType() != null) {
            return this.j2eeModule;
        }
        return null;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this.moduleChangeReporter;
    }

    public FileObject[] getSourceRoots() {
        Collection additional;
        FileObject fo;
        int i;
        HashSet<FileObject> fos = new HashSet<FileObject>();
        Sources sources = this.project.getSources();
        SourceGroup[] grps = sources.getSourceGroups("Resources");
        for (i = 0; i < grps.length; ++i) {
            fos.add(grps[i].getRootFolder());
        }
        grps = sources.getSourceGroups("java");
        for (i = 0; i < grps.length; ++i) {
            fos.add(grps[i].getRootFolder());
        }
        URI generated = this.project.getGeneratedSourcesDir();
        if (generated != null && (fo = FileUtilities.convertURItoFileObject((URI)generated)) != null) {
            fos.add(fo);
        }
        if ((additional = this.project.getAdditionalGeneratedSourceDirs()) != null) {
            Iterator it = additional.iterator();
            while (it.hasNext()) {
                FileObject fo2 = FileUtilities.convertURItoFileObject((URI)((URI)it.next()));
                if (fo2 == null) continue;
                fos.add(fo2);
            }
        }
        return fos.toArray(new FileObject[fos.size()]);
    }

    public String getDeploymentName() {
        String ret = super.getDeploymentName();
        return ret;
    }

    public void setServerInstanceID(String str) {
        this.serverId = str;
    }

    public boolean useDefaultServer() {
        return this.serverId == null && this.project.getPropertyResolver().getValue(SERVERID_PROPERTY) == null;
    }

    public String getServerInstanceID() {
        if (this.serverId != null && Deployment.getDefault().getServerID(this.serverId) != null) {
            return this.serverId;
        }
        String custom = this.project.getPropertyResolver().getResolvedValue(SERVERID_PROPERTY);
        if (custom != null && Deployment.getDefault().getServerID(custom) != null) {
            return custom;
        }
        return super.getServerInstanceID();
    }

    public String getServerID() {
        String toRet;
        String tr;
        if (this.serverId != null && (tr = Deployment.getDefault().getServerID(this.serverId)) != null) {
            return tr;
        }
        String custom = this.project.getPropertyResolver().getResolvedValue(SERVERID_PROPERTY);
        if (custom != null && (toRet = Deployment.getDefault().getServerID(custom)) != null) {
            return toRet;
        }
        return super.getServerID();
    }

    private class ModuleChangeReporterImpl
    implements ModuleChangeReporter {
        private ModuleChangeReporterImpl() {
        }

        public EjbChangeDescriptor getEjbChanges(long param) {
            return null;
        }

        public boolean isManifestChanged(long param) {
            return false;
        }
    }
}

