/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee;

import java.io.File;
import java.io.IOException;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenEarImpl
implements EarImplementation {
    private MavenProject project;

    public MavenEarImpl(MavenProject proj) {
        this.project = proj;
    }

    public void addEjbJarModule(EjbJar module) {
        throw new IllegalStateException("Not implemented yet for Maven projects");
    }

    public void addWebModule(WebModule module) {
        throw new IllegalStateException("Not implemented yet for Maven projects");
    }

    public FileObject getDeploymentDescriptor() {
        File guessed = MavenEarImpl.guessEarDescriptor(this.project);
        return guessed == null ? null : FileUtil.toFileObject((File)guessed);
    }

    public String getJ2eePlatformVersion() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                Application app = prov.getDDRoot(dd);
                String appVersion = app.getVersion().toString();
                return appVersion;
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        return "1.3";
    }

    public FileObject getMetaInf() {
        FileObject toRet;
        FileObject fo = FileUtilities.getFileObjectForProperty((String)"maven.ear.src", (IPropertyResolver)this.project.getPropertyResolver());
        if (fo != null && (toRet = fo.getFileObject("META-INF")) != null) {
            return toRet;
        }
        Sources srcs = this.project.getSources();
        SourceGroup[] grps = srcs.getSourceGroups("Resources");
        if (grps != null) {
            for (int i = 0; i < grps.length; ++i) {
                fo = grps[0].getRootFolder().getFileObject("META-INF");
                if (fo == null) continue;
                return fo;
            }
        }
        return null;
    }

    public static File guessEarDescriptor(MavenProject project) {
        File fo;
        if (MavenEarImpl.generatingAppDescriptor(project) && (fo = FileUtilities.getFileForProperty((String)"maven.ear.descriptordir", (IPropertyResolver)project.getPropertyResolver())) != null) {
            return new File(fo, "application.xml");
        }
        fo = FileUtilities.getFileForProperty((String)"maven.ear.appxml", (IPropertyResolver)project.getPropertyResolver());
        if (fo != null && fo.exists()) {
            return fo;
        }
        Sources srcs = project.getSources();
        SourceGroup[] grps = srcs.getSourceGroups("Resources");
        if (grps != null) {
            for (int i = 0; i < grps.length; ++i) {
                fo = FileUtil.toFile((FileObject)grps[0].getRootFolder());
                File toRet = new File(fo, "META-INF/application.xml");
                if (!toRet.exists()) continue;
                return toRet;
            }
        }
        return FileUtilities.getFileForProperty((String)"maven.ear.appxml", (IPropertyResolver)project.getPropertyResolver());
    }

    public boolean isValid() {
        return this.getDeploymentDescriptor() != null || MavenEarImpl.generatingAppDescriptor(this.project);
    }

    private static boolean generatingAppDescriptor(MavenProject project) {
        String val = project.getPropertyResolver().getResolvedValue("maven.ear.appxml.generate");
        return Boolean.valueOf(val).equals(Boolean.TRUE) || "yes".equalsIgnoreCase(val);
    }
}

