/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.deploy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.codehaus.cargo.container.Container;
import org.mevenide.netbeans.cargo.AddContainerAction;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.mevenide.netbeans.project.MavenProject;

public class DeployPanel
extends JPanel {
    private MavenProject project;
    private JButton btnAddContainer;
    private JButton btnUrl;
    private JCheckBox cbOpenInBrowser;
    private JComboBox comContainer;
    private JLabel lblContainer;
    private JLabel lblContext;
    private JLabel lblFile;
    private JLabel lblInfo;
    private JLabel lblUrl;
    private JLabel lblWebpage;
    private JTextField txtContext;
    private JTextField txtFile;
    private JTextField txtUrl;
    private JTextField txtWebpage;

    public DeployPanel() {
        this.initComponents();
        List listener = new List();
        this.comContainer.addActionListener(listener);
        this.btnUrl.addActionListener(listener);
        this.btnAddContainer.addActionListener(listener);
        this.txtContext.getDocument().addDocumentListener(listener);
        this.txtWebpage.getDocument().addDocumentListener(listener);
    }

    public DeployPanel(MavenProject proj) {
        this();
        this.project = proj;
    }

    private void refreshFields() {
        File war = this.project.getWar();
        if (war != null) {
            this.txtFile.setText(war.toString());
            String context = this.project.getContext().getPOMContext().getFinalProject().getArtifactId();
            if (context == null) {
                context = this.project.getContext().getPOMContext().getFinalProject().getId();
            }
            if (this.txtContext.getText() == null || this.txtContext.getText().trim().length() == 0) {
                this.txtContext.setText(context);
            }
        } else {
            this.txtFile.setText("");
        }
    }

    private void reloadAvailableContainers() {
        Collection containers = CargoServerRegistry.getInstance().getContainers();
        if (containers != null) {
            DefaultComboBoxModel<ContainerWrapper> model = new DefaultComboBoxModel<ContainerWrapper>();
            Iterator it = containers.iterator();
            while (it.hasNext()) {
                Container cont = (Container)it.next();
                model.addElement(new ContainerWrapper(cont));
            }
            this.comContainer.setModel(model);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.reloadAvailableContainers();
        if (this.comContainer.getSelectedItem() == null && this.comContainer.getModel().getSize() > 0) {
            this.comContainer.setSelectedIndex(0);
            this.txtUrl.setText(this.getBaseUrl());
        }
        this.refreshFields();
    }

    public Container getSelectedContainer() {
        Object sel = this.comContainer.getSelectedItem();
        return sel == null ? null : ((ContainerWrapper)sel).getContainer();
    }

    public String getDeployable() {
        return this.txtFile.getText();
    }

    public String getContext() {
        return this.txtContext.getText();
    }

    public String getBaseUrl() {
        Object sel = this.comContainer.getSelectedItem();
        if (sel == null) {
            return "";
        }
        Container cont = ((ContainerWrapper)sel).getContainer();
        String hostname = cont.getConfiguration().getPropertyValue("cargo.hostname");
        String port = cont.getConfiguration().getPropertyValue("cargo.servlet.port");
        boolean hasContext = this.txtContext.getText().trim().length() > 0;
        boolean hasPage = this.txtWebpage.getText().trim().length() > 0;
        return "http://" + hostname + ":" + port + (hasContext ? "/" : "") + this.txtContext.getText() + (hasPage ? "/" : "") + this.txtWebpage.getText();
    }

    public boolean showInBrowser() {
        return this.cbOpenInBrowser.isSelected();
    }

    private void initComponents() {
        this.lblContainer = new JLabel();
        this.comContainer = new JComboBox();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.lblContext = new JLabel();
        this.txtContext = new JTextField();
        this.cbOpenInBrowser = new JCheckBox();
        this.txtWebpage = new JTextField();
        this.btnUrl = new JButton();
        this.btnAddContainer = new JButton();
        this.lblUrl = new JLabel();
        this.txtUrl = new JTextField();
        this.lblWebpage = new JLabel();
        this.lblInfo = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblContainer.setText("Select Container :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.comContainer, gridBagConstraints);
        this.lblFile.setText("War :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtFile, gridBagConstraints);
        this.lblContext.setText("Context :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblContext, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtContext, gridBagConstraints);
        this.cbOpenInBrowser.setText("Open in Browser");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbOpenInBrowser, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.txtWebpage, gridBagConstraints);
        this.btnUrl.setText("Select...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.btnUrl, gridBagConstraints);
        this.btnAddContainer.setText("Add Container...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.btnAddContainer, gridBagConstraints);
        this.lblUrl.setText("URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.lblUrl, gridBagConstraints);
        this.txtUrl.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtUrl, gridBagConstraints);
        this.lblWebpage.setText("Page :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblWebpage, gridBagConstraints);
        this.lblInfo.setText("<html>Maven projects can use Cargo APIs (http://cargo.codehaus.org) for deployment. Please refer to Cargo's website for detailed information about supported J2EE containers and features supported for given container. </html>");
        this.lblInfo.setMinimumSize(new Dimension(300, 50));
        this.lblInfo.setPreferredSize(new Dimension(400, 75));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.lblInfo, gridBagConstraints);
    }

    private class List
    implements ActionListener,
    DocumentListener {
        private List() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DeployPanel.this.comContainer) {
                this.update();
            }
            if (e.getSource() == DeployPanel.this.btnUrl) {
                // empty if block
            }
            if (e.getSource() == DeployPanel.this.btnAddContainer) {
                new AddContainerAction().actionPerformed(e);
                DeployPanel.this.reloadAvailableContainers();
            }
        }

        private void update() {
            DeployPanel.this.txtUrl.setText(DeployPanel.this.getBaseUrl());
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }
    }

    private static class ContainerWrapper {
        private Container container;

        public ContainerWrapper(Container cont) {
            this.container = cont;
        }

        public Container getContainer() {
            return this.container;
        }

        public String toString() {
            return this.container.getName();
        }
    }
}

