/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.deploy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.configuration.StandaloneConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.URLDeployableMonitor;
import org.mevenide.netbeans.cargo.CargoServerRegistry;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;

public class DeployerRunner
implements Runnable {
    private Container container;
    private String deployable;
    private String context;
    private String baseurl;
    private WAR war;

    public DeployerRunner(Container cont, String depl, String url, String ctx) {
        this.container = cont;
        this.deployable = depl;
        this.baseurl = url;
        this.context = ctx;
    }

    public DeployerRunner(Container cont, WAR existingWar) {
        this.container = cont;
        this.war = existingWar;
    }

    public void run() {
        if (!CargoServerRegistry.getInstance().supportsDynamicDeployment(this.container)) {
            this.doStaticDeployment();
        } else {
            this.doDynamicDeployment();
        }
    }

    private void doStaticDeployment() {
        CargoServerRegistry reg = CargoServerRegistry.getInstance();
        if (this.container.getState() == State.STARTED) {
            StatusDisplayer.getDefault().setStatusText("Stopping Container " + this.container.getName());
            reg.stopContainer(this.container);
        }
        if (this.container.getConfiguration() instanceof StandaloneConfiguration) {
            StandaloneConfiguration config = (StandaloneConfiguration)this.container.getConfiguration();
            if (this.war == null) {
                Collection col = reg.getDeployables(this.container);
                Iterator it = col.iterator();
                File fil = new File(this.deployable);
                while (it.hasNext()) {
                    Deployable depl = (Deployable)it.next();
                    if (!fil.equals(depl.getFile())) continue;
                    this.war = (WAR)depl;
                }
                if (this.war == null) {
                    this.war = reg.getDeployableFactory().createWAR(this.deployable);
                    this.war.setContext(this.context);
                    config.addDeployable((Deployable)this.war);
                }
            }
        } else {
            throw new IllegalStateException("Can only deploy with standalone configuration");
        }
        StatusDisplayer.getDefault().setStatusText("Starting Container " + this.container.getName());
        reg.startContainer(this.container, false);
        if (this.baseurl != null) {
            try {
                URL url = new URL(this.baseurl);
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
            catch (MalformedURLException exc) {
                NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
            }
        }
        StatusDisplayer.getDefault().setStatusText("Statically Deployed " + (this.war == null ? this.deployable : this.war.getFile().toString()));
    }

    private void doDynamicDeployment() {
        CargoServerRegistry reg = CargoServerRegistry.getInstance();
        if (this.container.getState() == State.STOPPED) {
            StatusDisplayer.getDefault().setStatusText("Starting Container " + this.container.getName());
            reg.startContainer(this.container, false);
        }
        if (this.container.getState() == State.STARTED) {
            NotifyDescriptor.Message nd;
            StatusDisplayer.getDefault().setStatusText("Dynamically deploying " + this.deployable);
            if (this.war == null) {
                Collection col = reg.getDeployables(this.container);
                Iterator it = col.iterator();
                File fil = new File(this.deployable);
                while (it.hasNext()) {
                    Deployable depl = (Deployable)it.next();
                    if (!fil.equals(depl.getFile())) continue;
                    this.war = (WAR)depl;
                }
                if (this.war == null) {
                    this.war = reg.getDeployableFactory().createWAR(this.deployable);
                    this.war.setContext(this.context);
                }
            }
            Deployer deployer = reg.getDeployer(this.container);
            if (this.baseurl != null) {
                try {
                    final URL url = new URL(this.baseurl);
                    URLDeployableMonitor mon = new URLDeployableMonitor(url);
                    mon.registerListener(new DeployableMonitorListener(){

                        public void deployed() {
                            StatusDisplayer.getDefault().setStatusText("Dynamically Deployed " + DeployerRunner.this.deployable);
                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                        }
                    });
                    deployer.deploy((Deployable)this.war, (DeployableMonitor)mon);
                    reg.registerDeployable(this.container, (Deployable)this.war);
                }
                catch (MalformedURLException exc) {
                    NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                }
                catch (ContainerException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            } else {
                try {
                    deployer.deploy((Deployable)this.war);
                    reg.registerDeployable(this.container, (Deployable)this.war);
                    StatusDisplayer.getDefault().setStatusText("Dynamically Deployed at " + this.container.getName() + " ...");
                }
                catch (ContainerException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    nd = new NotifyDescriptor.Message((Object)exc.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        }
    }
}

