/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.j2ee.web;

import java.io.File;
import java.io.IOException;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WebModuleImpl
implements WebModuleImplementation {
    private MavenProject project;

    public WebModuleImpl(MavenProject proj) {
        this.project = proj;
    }

    public FileObject getWebInf() {
        FileObject fo = FileUtilities.getFileObjectForProperty((String)"maven.war.src", (IPropertyResolver)this.project.getPropertyResolver());
        if (fo != null) {
            return fo.getFileObject("WEB-INF");
        }
        return fo;
    }

    public String getJ2eePlatformVersion() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                WebApp wa = prov.getDDRoot(dd);
                String waVersion = wa.getVersion();
                if ("2.4".equals(waVersion)) {
                    return "1.4";
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        return "1.3";
    }

    public FileObject getDocumentBase() {
        FileObject docbase = FileUtilities.getFileObjectForProperty((String)"maven.war.src", (IPropertyResolver)this.project.getPropertyResolver());
        return docbase;
    }

    public FileObject getDeploymentDescriptor() {
        return FileUtilities.getFileObjectForProperty((String)"maven.war.webxml", (IPropertyResolver)this.project.getPropertyResolver());
    }

    public String getContextPath() {
        return "/" + this.project.getPropertyResolver().resolveString("${pom.artifactId}");
    }

    public boolean isValid() {
        boolean hasWarSrc = null != FileUtilities.getFileObjectForProperty((String)"maven.war.src", (IPropertyResolver)this.project.getPropertyResolver());
        boolean redefinedDescLocation = this.project.getPropertyLocator().getPropertyLocation("maven.war.webxml") != -2;
        boolean hasDescriptor = this.getDeploymentDescriptor() != null;
        return hasDescriptor;
    }

    public static File guessWebDescriptor(MavenProject project) {
        File fo = FileUtilities.getFileForProperty((String)"maven.war.webxml", (IPropertyResolver)project.getPropertyResolver());
        if (fo != null && fo.exists()) {
            return fo;
        }
        Sources srcs = project.getSources();
        SourceGroup[] grps = srcs.getSourceGroups("Resources");
        if (grps != null) {
            for (int i = 0; i < grps.length; ++i) {
                fo = FileUtil.toFile((FileObject)grps[0].getRootFolder());
                File toRet = new File(fo, "WEB-INF/web.xml");
                if (!toRet.exists()) continue;
                return toRet;
            }
        }
        return FileUtilities.getFileForProperty((String)"maven.war.webxml", (IPropertyResolver)project.getPropertyResolver());
    }
}

