/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.maven.project.Dependency;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.properties.IPropertyResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class FileUtilities {
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileUtilities() {
    }

    public static FileObject findFolder(FileObject rootFolder, String relPath) {
        File fl;
        if (rootFolder != null && (fl = FileUtil.toFile((FileObject)rootFolder)) != null) {
            File result = new File(fl, relPath);
            result = FileUtil.normalizeFile((File)result);
            return FileUtil.toFileObject((File)result);
        }
        return null;
    }

    public static FileObject findOrCreate(FileObject rootFolder, String relPath) throws IOException {
        FileObject parentFolder = rootFolder;
        FileObject folder = rootFolder;
        StringTokenizer tok = new StringTokenizer(relPath, "/", false);
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            folder = parentFolder.getFileObject(name, null);
            if (folder == null) {
                parentFolder.createFolder(name);
            }
            parentFolder = folder;
        }
        return folder;
    }

    public static FileObject convertURItoFileObject(URI uri) {
        if (uri == null) {
            return null;
        }
        File fil = new File(uri);
        return FileUtil.toFileObject((File)fil);
    }

    public static URI getDependencyURI(Dependency dependency, MavenProject project) {
        ILocationFinder finder = project.getLocFinder();
        File repo = new File(finder.getMavenLocalRepository());
        return FileUtilities.getDependencyURI(dependency, repo, project.getPropertyResolver());
    }

    static URI getDependencyURI(Dependency dependency, File repoFile, IPropertyResolver res) {
        StringBuffer buff = new StringBuffer();
        buff.append(res.resolveString(dependency.getArtifactDirectory()));
        buff.append(File.separator);
        String type = res.resolveString(dependency.getType());
        buff.append(type != null ? type : "jar");
        buff.append("s");
        buff.append(File.separator);
        if (dependency.getJar() == null) {
            String id = res.resolveString(dependency.getArtifactId());
            buff.append(id != null ? id : res.resolveString(dependency.getId()));
            buff.append("-");
            buff.append(res.resolveString(dependency.getVersion()));
            buff.append(".");
            String extension = res.resolveString(dependency.getExtension());
            buff.append(extension != null ? extension : "jar");
        } else {
            buff.append(res.resolveString(dependency.getJar()));
        }
        File file = new File(repoFile, buff.toString());
        file = FileUtil.normalizeFile((File)file);
        return file.toURI();
    }

    public static File locationToFile(int location, MavenProject project) {
        IQueryContext context = project.getContext();
        if (location >= 0 && location < 9) {
            File[] fls = context.getPOMContext().getProjectFiles();
            if (fls.length > location) {
                return fls[location];
            }
            return null;
        }
        if (location == 10) {
            return new File(context.getProjectDirectory(), "project.properties");
        }
        if (location == 11) {
            return new File(context.getProjectDirectory(), "build.properties");
        }
        if (location == 12) {
            return new File(context.getUserDirectory(), "build.properties");
        }
        int loc = location / 10;
        int offset = location % 10;
        File[] fls = context.getPOMContext().getProjectFiles();
        if (fls.length >= loc) {
            return new File(fls[loc - 1].getParentFile(), offset == 1 ? "build.properties" : "project.properties");
        }
        throw new IllegalArgumentException("Wrong argument. is=" + location);
    }

    public static FileObject[] findSelectedFiles(Lookup context, FileObject dir, String suffix) {
        if (dir != null && !dir.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + dir);
        }
        if (suffix != null && suffix.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cannot includes slashes in suffix: " + suffix);
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Iterator it = context.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
        while (it.hasNext()) {
            boolean matches;
            DataObject d = (DataObject)it.next();
            FileObject f = d.getPrimaryFile();
            boolean bl = matches = FileUtil.toFile((FileObject)f) != null;
            if (dir != null) {
                matches &= FileUtil.isParentOf((FileObject)dir, (FileObject)f) || dir == f;
            }
            if (suffix != null) {
                matches &= f.getNameExt().endsWith(suffix);
            }
            if (!matches) continue;
            files.add(f);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Iterator it = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
        while (it.hasNext()) {
            DataObject d = (DataObject)it.next();
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public static void delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    FileUtilities.delete(files[i]);
                }
            }
            file.delete();
        }
    }

    public static FileObject findTestForFile(MavenProject project, FileObject f) {
        if (f == null || !"java".equals(f.getExt())) {
            return null;
        }
        File testRootFile = new File(project.getTestSrcDirectory());
        FileObject testroot = FileUtil.toFileObject((File)testRootFile);
        if (testroot != null && FileUtil.isParentOf((FileObject)testroot, (FileObject)f)) {
            return f;
        }
        FileObject srcroot = FileUtil.toFileObject((File)new File(project.getSrcDirectory()));
        if (srcroot != null && FileUtil.isParentOf((FileObject)srcroot, (FileObject)f)) {
            String relative = FileUtil.getRelativePath((FileObject)srcroot, (FileObject)f);
            File testFile = new File(testRootFile, (relative = relative.substring(0, relative.length() - f.getNameExt().length())) + f.getName() + "Test.java");
            if (testFile.exists()) {
                return FileUtil.toFileObject((File)testFile);
            }
        }
        return null;
    }

    public static FileObject getFileObjectForProperty(String prop, IPropertyResolver resolver) {
        String val = resolver.getResolvedValue(prop);
        if (val != null) {
            File fil = new File(val);
            FileObject fo = FileUtil.toFileObject((File)(fil = FileUtil.normalizeFile((File)fil)));
            if (fo != null) {
                return fo;
            }
        }
        return null;
    }

    public static File resolveFilePath(File basedir, String filename) throws IllegalArgumentException {
        if (basedir == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (filename == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!basedir.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + basedir);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(filename).matches()) {
            return new File(basedir, filename.replace('/', File.separatorChar));
        }
        String machinePath = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File f = new File(machinePath);
        if (!f.isAbsolute()) {
            f = new File(basedir, machinePath);
        }
        if (!$assertionsDisabled && !f.isAbsolute()) {
            throw new AssertionError();
        }
        return new File(f.toURI().normalize());
    }

    static {
        $assertionsDisabled = !FileUtilities.class.desiredAssertionStatus();
        RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
    }
}

