/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.context.IQueryErrorCallback;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.LocationFinderAggregator;
import org.mevenide.netbeans.api.project.AdditionalMavenLookupProvider;
import org.mevenide.netbeans.project.ActionProviderImpl;
import org.mevenide.netbeans.project.CustomizerProviderImpl;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.LogicalViewProviderImpl;
import org.mevenide.netbeans.project.MavenSourcesImpl;
import org.mevenide.netbeans.project.ProjectOpenedHookImpl;
import org.mevenide.netbeans.project.SubprojectProviderImpl;
import org.mevenide.netbeans.project.classpath.ClassPathProviderImpl;
import org.mevenide.netbeans.project.queries.MavenForBinaryQueryImpl;
import org.mevenide.netbeans.project.queries.MavenSharabilityQueryImpl;
import org.mevenide.netbeans.project.queries.MavenTestForSourceImpl;
import org.mevenide.properties.IPropertyLocator;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.properties.resolver.ProjectWalker2;
import org.mevenide.properties.resolver.PropertyLocatorFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MavenProject
implements Project {
    private static final Log logger = LogFactory.getLog((Class)MavenProject.class);
    public static final String PROP_PROJECT = "MavenProject";
    private FileObject fileObject;
    private IPropertyResolver properties;
    private IQueryContext queryContext;
    private ILocationFinder locFinder;
    private IPropertyLocator propertyLocator;
    private ProjectWalker2 walker;
    private Image icon;
    private Lookup lookup;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Updater updater1;
    private Updater updater2;
    private Updater updater3;
    private Sources sources;
    private Info projectInfo;
    private static final String[] DEFAULT_FILES = new String[]{"build.properties", "project.properties", "project.xml"};
    private static final String[] USER_DIR_FILES = new String[]{"build.properties"};

    MavenProject(FileObject projectFO, File projectFile) throws Exception {
        this.fileObject = projectFO;
        this.projectInfo = new Info();
        this.updater1 = new Updater(true);
        this.updater2 = new Updater(true, USER_DIR_FILES);
        this.updater3 = new Updater(false);
        File projectDir = FileUtil.toFile((FileObject)this.fileObject.getParent());
        this.queryContext = new DefaultQueryContext(projectDir, (IQueryErrorCallback)this.projectInfo);
        this.properties = this.queryContext.getResolver();
        this.propertyLocator = PropertyLocatorFactory.getFactory().createContextBasedLocator(this.queryContext);
        this.locFinder = new LocationFinderAggregator(this.queryContext);
        this.walker = new ProjectWalker2(this.queryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void firePropertyChange(String property) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.projectInfo.reset();
            this.support.firePropertyChange(new PropertyChangeEvent(this, property, null, null));
        }
    }

    public String getDisplayName() {
        String displayName = this.projectInfo.getDisplayName();
        if (displayName == null) {
            displayName = "<Maven project with no name>";
        }
        return displayName;
    }

    public String getShortDescription() {
        String desc = this.projectInfo.getErrorDescription();
        if (desc == null) {
            desc = this.getOriginalMavenProject().getShortDescription();
        }
        if (desc == null) {
            desc = "A Maven based project";
        }
        return desc;
    }

    public org.apache.maven.project.Project getOriginalMavenProject() {
        return this.queryContext.getPOMContext().getFinalProject();
    }

    public IPropertyResolver getPropertyResolver() {
        return this.properties;
    }

    public ILocationFinder getLocFinder() {
        return this.locFinder;
    }

    public IPropertyLocator getPropertyLocator() {
        return this.propertyLocator;
    }

    public IQueryContext getContext() {
        return this.queryContext;
    }

    public ProjectWalker2 getProjectWalker() {
        return this.walker;
    }

    Updater getProjectFolderUpdater() {
        return this.updater1;
    }

    Updater getUserFolderUpdater() {
        return this.updater2;
    }

    Updater getFileUpdater() {
        return this.updater3;
    }

    public Image getIcon() {
        if (this.icon == null) {
            this.icon = Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/MavenIcon.gif");
        }
        return this.icon;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    public String getName() {
        String toReturn = this.getOriginalMavenProject().getId();
        if (toReturn == null) {
            toReturn = this.getProjectDirectory().getName() + " <No Project ID>";
        }
        return toReturn;
    }

    public Action createRefreshAction() {
        return new RefreshAction();
    }

    public FileObject getProjectDirectory() {
        return this.fileObject.getParent();
    }

    public URI getSrcDirectory() {
        String path;
        if (this.getOriginalMavenProject().getBuild() != null && (path = this.getOriginalMavenProject().getBuild().getSourceDirectory()) != null) {
            return this.getDirURI(this.getPropertyResolver().resolveString(path));
        }
        path = this.properties.getResolvedValue("maven.src.dir");
        if (path == null) {
            logger.warn((Object)"Strange thing here. src dir not found.");
            return null;
        }
        File fl = new File(path, "java");
        return FileUtil.normalizeFile((File)fl).toURI();
    }

    public URI getTestSrcDirectory() {
        String path;
        if (this.getOriginalMavenProject().getBuild() != null && (path = this.getOriginalMavenProject().getBuild().getUnitTestSourceDirectory()) != null) {
            return this.getDirURI(this.getPropertyResolver().resolveString(path));
        }
        path = this.properties.getResolvedValue("maven.src.dir");
        if (path == null) {
            logger.warn((Object)"Strange thing here. testsrc dir not found.");
            return null;
        }
        File fl = new File(path, "test/java");
        return FileUtil.normalizeFile((File)fl).toURI();
    }

    public URI getAspectsDirectory() {
        String path;
        if (this.getOriginalMavenProject().getBuild() != null && (path = this.getOriginalMavenProject().getBuild().getAspectSourceDirectory()) != null) {
            return this.getDirURI(this.getPropertyResolver().resolveString(path));
        }
        path = this.properties.getResolvedValue("maven.src.dir");
        if (path == null) {
            logger.warn((Object)"Strange thing here. src dir not found.");
            return null;
        }
        File fl = new File(path, "aspects");
        return FileUtil.normalizeFile((File)fl).toURI();
    }

    public URI getIntegrationTestsDirectory() {
        String path;
        if (this.getOriginalMavenProject().getBuild() != null && (path = this.getOriginalMavenProject().getBuild().getIntegrationUnitTestSourceDirectory()) != null) {
            return this.getDirURI(this.getPropertyResolver().resolveString(path));
        }
        path = this.properties.getResolvedValue("maven.src.dir");
        if (path == null) {
            logger.warn((Object)"Strange thing here. src dir not found.");
            return null;
        }
        File fl = new File(path, "test/integration");
        return FileUtil.normalizeFile((File)fl).toURI();
    }

    public URI getWebAppDirectory() {
        String path = this.getPropertyResolver().getResolvedValue("maven.war.src");
        return path == null ? null : this.getDirURI(path);
    }

    public File getWar() {
        String buildDir = this.getPropertyResolver().getResolvedValue("maven.war.build.dir");
        String name = this.getPropertyResolver().getResolvedValue("maven.war.final.name");
        if (name != null && buildDir != null) {
            File fil = new File(buildDir, name + ".war");
            return fil;
        }
        return null;
    }

    public URI getEarDirectory() {
        String path = this.getPropertyResolver().getResolvedValue("maven.ear.src");
        return path == null ? null : this.getDirURI(path);
    }

    public URI getEjbDirectory() {
        String path = this.getPropertyResolver().getResolvedValue("maven.ejb.src");
        return path == null ? null : this.getDirURI(path);
    }

    public URI getCactusDirectory() {
        String path = this.getPropertyResolver().getResolvedValue("cactus.src.dir");
        return path == null ? null : this.getDirURI(path);
    }

    private URI getDirURI(String path) {
        File src = FileUtilities.resolveFilePath(FileUtil.toFile((FileObject)this.getProjectDirectory()), path);
        return FileUtil.normalizeFile((File)src).toURI();
    }

    public URI getBuildClassesDir() {
        String path = this.properties.getResolvedValue("maven.build.dest");
        if (path != null) {
            File fl = new File(path);
            return FileUtil.normalizeFile((File)fl).toURI();
        }
        logger.warn((Object)"maven.build.dest not defined.");
        return null;
    }

    public URI getGeneratedSourcesDir() {
        String path = this.properties.getResolvedValue("maven.build.src");
        if (path != null) {
            File fl = new File(path);
            return FileUtil.normalizeFile((File)fl).toURI();
        }
        logger.warn((Object)"maven.build.src not defined.");
        return null;
    }

    public Collection getAdditionalGeneratedSourceDirs() {
        File fl;
        String path = this.properties.getResolvedValue("maven.gen.src");
        if (path != null && (fl = new File(path)).exists() && fl.isDirectory()) {
            ArrayList<URI> col = new ArrayList<URI>();
            File[] fls = fl.listFiles();
            for (int i = 0; i < fls.length; ++i) {
                if (!fls[i].isDirectory()) continue;
                col.add(FileUtil.normalizeFile((File)fl).toURI());
            }
            return col;
        }
        return Collections.EMPTY_LIST;
    }

    public URI getTestBuildClassesDir() {
        String path = this.properties.getResolvedValue("maven.test.dest");
        if (path != null) {
            File fl = new File(path);
            return FileUtil.normalizeFile((File)fl).toURI();
        }
        logger.warn((Object)"maven.test.dest not defined.");
        return null;
    }

    public synchronized Sources getSources() {
        if (this.sources == null) {
            this.sources = new MavenSourcesImpl(this);
        }
        return this.sources;
    }

    private Lookup createLookup() {
        ArrayList<Lookup> toReturn = new ArrayList<Lookup>();
        Lookup staticLookup = Lookups.fixed((Object[])new Object[]{this.projectInfo, new MavenForBinaryQueryImpl(this), new ActionProviderImpl(this), new CustomizerProviderImpl(this), new LogicalViewProviderImpl(this), new ProjectOpenedHookImpl(this), new ClassPathProviderImpl(this), new MavenSharabilityQueryImpl(this), new MavenTestForSourceImpl(this), new SubprojectProviderImpl(this), this.getSources(), new RecommendedTemplatesImpl()});
        toReturn.add(staticLookup);
        Lookup.Template template = new Lookup.Template(AdditionalMavenLookupProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection col = result.allInstances();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            AdditionalMavenLookupProvider prov = (AdditionalMavenLookupProvider)it.next();
            toReturn.add(prov.createMavenLookup(this));
        }
        Lookup[] lookups = new Lookup[toReturn.size()];
        lookups = toReturn.toArray(lookups);
        ProxyLookup look = new ProxyLookup(lookups);
        return look;
    }

    public ProjectInformation getProjectInfo() {
        return this.projectInfo;
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            this.putValue("Name", "Reload Project");
        }

        public void actionPerformed(ActionEvent event) {
            MavenProject.this.firePropertyChange(MavenProject.PROP_PROJECT);
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] APPLICATION_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "gui-java-application", "java-beans", "oasis-XML-catalogs", "XML", "servlet-types", "web-types", "junit", "MIDP", "maven-docs", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/GUIForms/JPanel.java", "Templates/GUIForms/JFrame.java"};

        RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return APPLICATION_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private class Updater
    implements FileChangeListener {
        private boolean isFolder;
        private String[] filesToWatch;

        Updater(boolean folder) {
            this(folder, DEFAULT_FILES);
        }

        Updater(boolean folder, String[] toWatch) {
            this.isFolder = folder;
            this.filesToWatch = toWatch;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            String nameExt;
            if (!this.isFolder && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1) {
                MavenProject.this.firePropertyChange(MavenProject.PROP_PROJECT);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            String nameExt;
            if (this.isFolder && Arrays.binarySearch(this.filesToWatch, nameExt = fileEvent.getFile().getNameExt()) != -1) {
                fileEvent.getFile().addFileChangeListener((FileChangeListener)MavenProject.this.getFileUpdater());
                MavenProject.this.firePropertyChange(MavenProject.PROP_PROJECT);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (!this.isFolder) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)MavenProject.this.getFileUpdater());
                MavenProject.this.firePropertyChange(MavenProject.PROP_PROJECT);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            MavenProject.this.firePropertyChange(MavenProject.PROP_PROJECT);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }

    private final class Info
    implements ProjectInformation,
    IQueryErrorCallback {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private String errorName;
        private boolean errorIcon;
        private String errorDescription;

        Info() {
        }

        public void reset() {
            this.firePropertyChange("displayName");
            this.pcs.firePropertyChange("icon", null, this.getIcon());
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            String toReturn = MavenProject.this.getName();
            return toReturn;
        }

        public String getDisplayName() {
            if (this.errorName != null) {
                return this.errorName;
            }
            String toReturn = MavenProject.this.getOriginalMavenProject().getName();
            if (toReturn == null) {
                toReturn = "<No name defined>";
            }
            return toReturn;
        }

        public Icon getIcon() {
            if (this.errorIcon) {
                return new ImageIcon(Utilities.mergeImages((Image)MavenProject.this.getIcon(), (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0));
            }
            return new ImageIcon(MavenProject.this.getIcon());
        }

        public Project getProject() {
            return MavenProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        public void handleError(int errorNumber, Exception exception) {
            this.errorIcon = true;
            if (errorNumber == -1) {
                this.errorName = "<Non-parseable POM file>";
            }
            if (errorNumber == -4) {
                this.errorName = "<Cannot find parent POM>";
            }
            if (errorNumber == -3) {
                this.errorName = "<Cannot find POM>";
            }
            if (exception != null) {
                this.errorDescription = exception.getMessage();
            }
        }

        public void discardError(int errorNumber) {
            this.errorIcon = false;
            this.errorName = null;
            this.errorDescription = null;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }
}

