/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.classpath.ClassPathProviderImpl;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.project.io.JarOverrideReader2;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private static final Log logger = LogFactory.getLog((Class)ProjectOpenedHookImpl.class);
    private MavenProject project;

    ProjectOpenedHookImpl(MavenProject proj) {
        this.project = proj;
    }

    protected void projectOpened() {
        logger.debug((Object)"Project opened.");
        this.attachUpdater();
        MavenFileOwnerQueryImpl q = MavenFileOwnerQueryImpl.getInstance();
        if (q != null) {
            q.addMavenProject(this.project);
        } else {
            logger.error((Object)"no query MavenFileOwnerQueryImpl :(");
        }
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
    }

    protected void projectClosed() {
        logger.debug((Object)"Project closed.");
        MavenFileOwnerQueryImpl q = MavenFileOwnerQueryImpl.getInstance();
        if (q != null) {
            q.removeMavenProject(this.project);
        } else {
            logger.error((Object)"no query MavenFileOwnerQueryImpl :(");
        }
        this.detachUpdater();
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
    }

    private void attachUpdater() {
        FileObject fo = FileUtil.toFileObject((File)this.project.getContext().getProjectDirectory());
        FileObject userFo = FileUtil.toFileObject((File)this.project.getContext().getUserDirectory());
        fo.addFileChangeListener((FileChangeListener)this.project.getProjectFolderUpdater());
        userFo.addFileChangeListener((FileChangeListener)this.project.getUserFolderUpdater());
        FileObject xml = fo.getFileObject("project.xml");
        FileObject prop = fo.getFileObject("project.properties");
        FileObject prop2 = fo.getFileObject("build.properties");
        FileObject prop3 = userFo.getFileObject("build.properties");
        if (xml != null) {
            xml.addFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop != null) {
            prop.addFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop2 != null) {
            prop2.addFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop3 != null) {
            prop3.addFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
    }

    private void detachUpdater() {
        FileObject fo = FileUtil.toFileObject((File)this.project.getContext().getProjectDirectory());
        FileObject userFo = FileUtil.toFileObject((File)this.project.getContext().getUserDirectory());
        fo.removeFileChangeListener((FileChangeListener)this.project.getProjectFolderUpdater());
        userFo.removeFileChangeListener((FileChangeListener)this.project.getUserFolderUpdater());
        FileObject xml = fo.getFileObject("project.xml");
        FileObject prop = fo.getFileObject("project.properties");
        FileObject prop2 = fo.getFileObject("build.properties");
        FileObject prop3 = userFo.getFileObject("build.properties");
        if (xml != null) {
            xml.removeFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop != null) {
            prop.removeFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop2 != null) {
            prop2.removeFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
        if (prop3 != null) {
            prop3.removeFileChangeListener((FileChangeListener)this.project.getFileUpdater());
        }
    }

    private boolean dependencyExists(Dependency dep) {
        if (dep.getType() == null || dep.isAddedToClasspath()) {
            String path = JarOverrideReader2.getInstance().processOverride(dep, this.project.getPropertyResolver(), this.project.getLocFinder());
            File file = path != null ? new File(path) : new File(FileUtilities.getDependencyURI(dep, this.project));
            logger.debug((Object)("dep path=" + path));
            return file.exists();
        }
        return false;
    }
}

