/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.mevenide.netbeans.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SubprojectProviderImpl
implements SubprojectProvider {
    private static final Log logger = LogFactory.getLog((Class)SubprojectProviderImpl.class);
    private static final String MULTIPROJECT_INCLUDES = "maven.multiproject.includes";
    private static final String MULTIPROJECT_EXCLUDES = "maven.multiproject.excludes";
    private static final String MULTIPROJECT_BASEDIR = "maven.multiproject.basedir";
    private MavenProject project;

    public SubprojectProviderImpl(MavenProject proj) {
        this.project = proj;
    }

    public Set getSubprojects() {
        logger.debug((Object)"getSubProjects()");
        String includes = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_INCLUDES);
        String excludes = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_EXCLUDES);
        String basedir = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_BASEDIR);
        int includesLocation = this.project.getPropertyLocator().getPropertyLocation(MULTIPROJECT_INCLUDES);
        if (includes != null && includesLocation > -2) {
            HashSet<Project> toReturn = new HashSet<Project>();
            File basefile = FileUtil.normalizeFile((File)new File(basedir));
            if (basefile.exists()) {
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(basefile);
                if (excludes != null) {
                    String[] exc = StringUtils.split((String)excludes, (String)",");
                    scanner.setExcludes(exc);
                }
                String[] inc = StringUtils.split((String)includes, (String)",");
                scanner.setIncludes(inc);
                scanner.scan();
                String[] results = scanner.getIncludedFiles();
                for (int i = 0; i < results.length; ++i) {
                    Project proj = this.processOneSubproject(basefile, results[i]);
                    if (proj == null) continue;
                    toReturn.add(proj);
                }
            } else {
                logger.debug((Object)("basefile not found=" + basedir));
            }
            return toReturn;
        }
        return Collections.EMPTY_SET;
    }

    private Project processOneSubproject(File basefile, String relPath) {
        File projectFile = FileUtil.normalizeFile((File)new File(basefile.getAbsolutePath() + File.separator + relPath));
        if (projectFile.exists()) {
            FileObject projectDir = FileUtil.toFileObject((File)projectFile);
            if (projectDir != null) {
                projectDir = projectDir.getParent();
                if (this.project.getProjectDirectory().equals(projectDir)) {
                    return null;
                }
                if (ProjectManager.getDefault().isProject(projectDir)) {
                    try {
                        Project proj = ProjectManager.getDefault().findProject(projectDir);
                        return proj;
                    }
                    catch (IOException exc) {
                        logger.debug((Object)"IO exc. while loading project", (Throwable)exc);
                    }
                }
            } else {
                logger.debug((Object)("fileobject not found=" + relPath + " in basedir=" + basefile));
            }
        } else {
            logger.debug((Object)("project file not found=" + relPath + " in basedir=" + basefile));
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

