/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.netbeans.project.dependencies.DependencyEditor;
import org.mevenide.netbeans.project.dependencies.DependencyNode;
import org.mevenide.netbeans.project.dependencies.RepositoryUtilities;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.RepoPathElement;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class DependenciesPanel
extends JPanel
implements ExplorerManager.Provider,
ProjectPanel {
    private MavenProject project;
    private ExplorerManager manager;
    private BeanTreeView btv;
    private boolean initialized = false;
    private boolean isResolvingValues = false;
    private OriginChange ocDummyDependency;
    private OriginChange ocDummyOverride;
    private List values = new ArrayList();
    private DependencyPOMChange currentDep;
    private DependencyPOMChange emptyDep;
    private List overrideValues = new ArrayList();
    private JButton btnAdd;
    private JButton btnCheck;
    private JButton btnEdit;
    private JButton btnLoc;
    private JButton btnOverride;
    private JButton btnRemove;
    private JButton btnView;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JLabel lblArtifactId;
    private JLabel lblGroupId;
    private JLabel lblJar;
    private JLabel lblJavadocSrc;
    private JLabel lblType;
    private JLabel lblURL;
    private JLabel lblVersion;
    private JList lstProperties;
    private JPanel pnlDeps;
    private JPanel pnlOverrides;
    private JPanel pnlSingleDep;
    private JRadioButton rbPath;
    private JRadioButton rbVersion;
    private JTabbedPane tbDep;
    private JTextField txtArtifactID;
    private JTextField txtGroupId;
    private JTextField txtJar;
    private JTextField txtType;
    private JTextField txtURL;
    private JTextField txtVersion;

    public DependenciesPanel(MavenProject proj, boolean editable) {
        this.project = proj;
        this.ocDummyDependency = LocationComboFactory.createPOMChange(this.project, false);
        this.ocDummyOverride = LocationComboFactory.createPropertiesChange(this.project);
        this.initComponents();
        this.tbDep.setVisible(false);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.rbVersion);
        grp.add(this.rbPath);
        GridBagConstraints fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = 0;
        fillConstraints.gridheight = 0;
        fillConstraints.fill = 1;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;
        this.manager = new ExplorerManager();
        this.btv = new BeanTreeView();
        this.btv.setSelectionMode(1);
        this.btv.setPopupAllowed(false);
        this.btv.setRootVisible(false);
        this.btv.setDefaultActionAllowed(false);
        this.pnlDeps.add((Component)this.btv, fillConstraints);
        this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
        this.setFieldsEditable(editable);
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = DependenciesPanel.this.txtURL.getText().trim();
                url = DependenciesPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.emptyDep = new DependencyPOMChange("", new HashMap(), -1, this.createFieldMap(), this.ocDummyOverride, new HashMap(), false);
    }

    public void setFieldsEditable(boolean editable) {
        this.txtArtifactID.setEditable(editable);
        this.txtGroupId.setEditable(editable);
        this.txtVersion.setEditable(editable);
        this.txtType.setEditable(editable);
        this.txtURL.setEditable(editable);
        this.txtJar.setEditable(editable);
        this.lstProperties.setEnabled(editable);
    }

    private void initComponents() {
        this.pnlDeps = new JPanel();
        this.tbDep = new JTabbedPane();
        this.pnlOverrides = new JPanel();
        this.rbVersion = new JRadioButton();
        this.rbPath = new JRadioButton();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jButton1 = new JButton();
        this.btnOverride = new JButton();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnCheck = new JButton();
        this.pnlSingleDep = new JPanel();
        this.ocDummyDependency = LocationComboFactory.createPOMChange(this.project, true);
        this.btnLoc = (JButton)this.ocDummyDependency.getComponent();
        this.lblArtifactId = new JLabel();
        this.txtArtifactID = new JTextField();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblType = new JLabel();
        this.txtType = new JTextField();
        this.lblJar = new JLabel();
        this.txtJar = new JTextField();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.btnView = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstProperties = new JList();
        this.lblJavadocSrc = new JLabel();
        this.setLayout(new GridBagLayout());
        this.pnlDeps.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.pnlDeps, gridBagConstraints);
        this.tbDep.setTabLayoutPolicy(1);
        this.tbDep.setTabPlacement(3);
        this.pnlOverrides.setLayout(new GridBagLayout());
        this.rbVersion.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlOverrides.add((Component)this.rbVersion, gridBagConstraints);
        this.rbPath.setText("Artifact Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlOverrides.add((Component)this.rbPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlOverrides.add((Component)this.jTextField1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlOverrides.add((Component)this.jTextField2, gridBagConstraints);
        this.jButton1.setText("Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.pnlOverrides.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.pnlOverrides.add((Component)this.btnOverride, gridBagConstraints);
        this.tbDep.addTab("Overrides", this.pnlOverrides);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.tbDep, gridBagConstraints);
        this.btnAdd.setText("Add...");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setText("Edit...");
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setText("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnCheck.setText("Doc&Src check");
        this.btnCheck.setToolTipText("Contacts remote repositories requesting download of javadoc and source jars for the dependency.");
        this.btnCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependenciesPanel.this.btnCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnCheck, gridBagConstraints);
        this.pnlSingleDep.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.btnLoc, gridBagConstraints);
        this.lblArtifactId.setText("Artifact");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblArtifactId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.txtArtifactID, gridBagConstraints);
        this.lblGroupId.setText("Group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblGroupId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlSingleDep.add((Component)this.txtGroupId, gridBagConstraints);
        this.lblVersion.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.txtVersion, gridBagConstraints);
        this.lblType.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.pnlSingleDep.add((Component)this.txtType, gridBagConstraints);
        this.lblJar.setLabelFor(this.txtJar);
        this.lblJar.setText("Jar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblJar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.txtJar, gridBagConstraints);
        this.lblURL.setText("URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.lblURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.pnlSingleDep.add((Component)this.txtURL, gridBagConstraints);
        this.btnView.setText("View...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 3, 0, 3);
        this.pnlSingleDep.add((Component)this.btnView, gridBagConstraints);
        this.lstProperties.setMinimumSize(new Dimension(10, 50));
        this.jScrollPane1.setViewportView(this.lstProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(3, 3, 6, 3);
        this.pnlSingleDep.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblJavadocSrc.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        this.pnlSingleDep.add((Component)this.lblJavadocSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.pnlSingleDep, gridBagConstraints);
    }

    private void btnCheckActionPerformed(ActionEvent evt) {
        if (this.currentDep != null) {
            final IContentProvider prov = this.currentDep.getChangedContent();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    IRepositoryReader[] readers = RepositoryUtilities.createRemoteReaders(DependenciesPanel.this.project.getPropertyResolver());
                    for (int i = 0; i < readers.length; ++i) {
                        RepoPathElement docEl = new RepoPathElement(readers[i], null, prov.getValue("groupId"), "javadoc.jar", prov.getValue("version"), prov.getValue("artifactId"), "javadoc.jar");
                        RepoPathElement srcEl = new RepoPathElement(readers[i], null, prov.getValue("groupId"), "src.jar", prov.getValue("version"), prov.getValue("artifactId"), "src.jar");
                        File localRepo = new File(DependenciesPanel.this.project.getLocFinder().getMavenLocalRepository());
                        File destinationFile = new File(URI.create(localRepo.toURI().toString() + srcEl.getRelativeURIPath()));
                        if (!destinationFile.exists() || destinationFile.getName().indexOf("SNAPSHOT") >= 0) {
                            try {
                                RepositoryUtilities.downloadArtifact(DependenciesPanel.this.project.getLocFinder(), DependenciesPanel.this.project.getPropertyResolver(), srcEl);
                            }
                            catch (FileNotFoundException exc) {
                            }
                            catch (Exception exc) {
                                StatusDisplayer.getDefault().setStatusText("Error downloading " + destinationFile.getName() + " : " + exc.getLocalizedMessage());
                            }
                        }
                        if (!(destinationFile = new File(URI.create((localRepo = new File(DependenciesPanel.this.project.getLocFinder().getMavenLocalRepository())).toURI().toString() + docEl.getRelativeURIPath()))).exists() || destinationFile.getName().indexOf("SNAPSHOT") >= 0) {
                            try {
                                RepositoryUtilities.downloadArtifact(DependenciesPanel.this.project.getLocFinder(), DependenciesPanel.this.project.getPropertyResolver(), docEl);
                            }
                            catch (FileNotFoundException exc) {
                            }
                            catch (Exception exc) {
                                StatusDisplayer.getDefault().setStatusText("Error downloading " + destinationFile.getName() + " : " + exc.getLocalizedMessage());
                            }
                        }
                        ((DepRootChildren)DependenciesPanel.this.manager.getRootContext().getChildren()).doRefresh();
                    }
                }
            });
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (this.currentDep != null) {
            this.values.remove(this.currentDep);
            if (this.values.size() == 0) {
                this.btnLoc.setVisible(false);
            }
            ((DepRootChildren)this.manager.getRootContext().getChildren()).doRefresh();
            this.setDependency(this.manager.getSelectedNodes());
        }
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        DependencyEditor ed = new DependencyEditor(this.project, this.currentDep);
        DialogDescriptor dd = new DialogDescriptor((Object)ed, "title");
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            HashMap props = ed.getProperties();
            this.currentDep.setNewValues(ed.getValues(), props);
            ((DepRootChildren)this.manager.getRootContext().getChildren()).doRefresh();
            this.setDependency(this.manager.getSelectedNodes());
            MavenSettings.getDefault().checkDependencyProperties(props.keySet());
        }
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        DependencyPOMChange change = new DependencyPOMChange("pom.dependencies.dependency", new HashMap(), 0, this.createFieldMap(), this.ocDummyDependency, new HashMap(), false);
        DependencyEditor ed = new DependencyEditor(this.project, change);
        DialogDescriptor dd = new DialogDescriptor((Object)ed, "title");
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            HashMap props = ed.getProperties();
            change.setNewValues(ed.getValues(), props);
            this.values.add(change);
            if (this.values.size() == 1) {
                this.btnLoc.setVisible(true);
            }
            ((DepRootChildren)this.manager.getRootContext().getChildren()).doRefresh();
            MavenSettings.getDefault().checkDependencyProperties(props.keySet());
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        Project[] projs = this.project.getContext().getPOMContext().getProjectLayers();
        for (int i = 0; i < projs.length; ++i) {
            int location = i;
            List deps = projs[i].getDependencies();
            if (deps == null || deps.size() <= 0) continue;
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                HashMap<String, String> vals = new HashMap<String, String>();
                vals.put("artifactId", dep.getArtifactId());
                vals.put("groupId", dep.getGroupId());
                vals.put("version", dep.getVersion());
                vals.put("type", dep.getType());
                vals.put("jar", dep.getJar());
                vals.put("url", dep.getUrl());
                HashMap props = new HashMap();
                Map map = dep.resolvedProperties();
                if (map != null) {
                    Iterator it2 = map.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry ent = it2.next();
                        if (ent.getValue() == null || ent.getValue().toString().trim().length() <= 0) continue;
                        props.put(ent.getKey(), ent.getValue());
                    }
                }
                DependencyPOMChange change = new DependencyPOMChange("pom.dependencies.dependency", vals, location, this.createFieldMap(), this.ocDummyDependency, props, false);
                this.values.add(change);
                String overrideProp = "maven.jar." + dep.getArtifactId();
            }
        }
        if (this.values.size() == 0) {
            this.btnLoc.setVisible(false);
        }
        this.manager.setRootContext(this.createRootNode());
        this.selectFirstNode();
    }

    private HashMap createFieldMap() {
        HashMap<String, JTextField> fields = new HashMap<String, JTextField>();
        fields.put("artifactId", this.txtArtifactID);
        fields.put("groupId", this.txtGroupId);
        fields.put("version", this.txtVersion);
        fields.put("type", this.txtType);
        fields.put("jar", this.txtJar);
        fields.put("url", this.txtURL);
        return fields;
    }

    public void setResolveValues(boolean resolve) {
        this.isResolvingValues = resolve;
        this.resolveDependency(resolve, this.currentDep);
        this.btnRemove.setEnabled(!resolve);
        this.btnAdd.setEnabled(!resolve);
        this.btnEdit.setEnabled(!resolve);
    }

    private void resolveDependency(boolean resolve, DependencyPOMChange chng) {
        if (chng != null) {
            if (resolve) {
                IContentProvider prov = chng.getChangedContent();
                HashMap<String, String> resolved = new HashMap<String, String>();
                String value = prov.getValue("artifactId");
                if (value != null) {
                    resolved.put("artifactId", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("groupId")) != null) {
                    resolved.put("groupId", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("version")) != null) {
                    resolved.put("version", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("type")) != null) {
                    resolved.put("type", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("jar")) != null) {
                    resolved.put("jar", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("url")) != null) {
                    resolved.put("url", this.project.getPropertyResolver().resolveString(value));
                }
                chng.setResolvedValues(resolved);
            } else {
                chng.resetToNonResolvedValue();
            }
        }
    }

    public List getChanges() {
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
        return this.values;
    }

    private void selectFirstNode() {
        Node[] nodes;
        Children ch = this.manager.getRootContext().getChildren();
        if (ch != null && (nodes = ch.getNodes()) != null && nodes.length > 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{nodes[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private Node createRootNode() {
        AbstractNode root = new AbstractNode((Children)new DepRootChildren());
        root.setName("root invisible");
        return root;
    }

    private String getValue(String value, boolean resolve) {
        if (resolve) {
            return this.project.getPropertyResolver().resolveString(value);
        }
        return value;
    }

    public void setDependency(Node[] nodes) {
        boolean javadoc = false;
        boolean source = false;
        this.lblJavadocSrc.setText("");
        if (this.currentDep != null) {
            this.currentDep.detachListeners();
        }
        if (nodes == null || nodes.length <= 0) {
            this.currentDep = null;
            DefaultListModel model = new DefaultListModel();
            this.lstProperties.setModel(model);
            this.emptyDep.resetToNonResolvedValue();
            this.btnRemove.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnCheck.setEnabled(false);
            return;
        }
        Node node = nodes[0];
        DependencyPOMChange chan = (DependencyPOMChange)node.getLookup().lookup(DependencyPOMChange.class);
        if (chan != null) {
            chan.resetToNonResolvedValue();
            chan.attachListeners();
            DefaultListModel<String> model = new DefaultListModel<String>();
            List props = chan.getChangedContent().getProperties();
            if (props != null) {
                Iterator it = props.iterator();
                while (it.hasNext()) {
                    String ent = (String)it.next();
                    int index = ent.indexOf(58);
                    if (index <= 0) continue;
                    model.addElement(ent.substring(0, index) + "=" + ent.substring(index + 1));
                }
            }
            this.lstProperties.setModel(model);
            if (node instanceof DependencyNode) {
                DependencyNode depNode = (DependencyNode)node;
                javadoc = depNode.hasJavadocInRepository();
                source = depNode.hasSourceInRepository();
            }
            this.currentDep = chan;
            this.btnRemove.setEnabled(!this.isResolvingValues);
            this.btnAdd.setEnabled(!this.isResolvingValues);
            this.btnEdit.setEnabled(!this.isResolvingValues);
            this.btnCheck.setEnabled(!javadoc || !source);
        } else {
            this.currentDep = null;
        }
        if (javadoc && source) {
            this.lblJavadocSrc.setText("Javadoc and Sources are available.");
        } else if (javadoc) {
            this.lblJavadocSrc.setText("Javadoc for dependency available.");
        } else if (source) {
            this.lblJavadocSrc.setText("Sources for dependency available.");
        }
    }

    public String getValidityMessage() {
        return "";
    }

    public boolean isInValidState() {
        return true;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
    }

    private class DepRootChildren
    extends Children.Keys {
        private DepRootChildren() {
        }

        public void addNotify() {
            List depend = DependenciesPanel.this.values;
            if (depend != null) {
                this.setKeys(new ArrayList(depend));
            } else {
                this.setKeys(Collections.EMPTY_LIST);
            }
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        public void doRefresh() {
            this.setKeys(new ArrayList(DependenciesPanel.this.values));
            Node[] nds = this.getNodes();
            for (int i = 0; i < nds.length; ++i) {
                if (!(nds[i] instanceof DependencyNode)) continue;
                ((DependencyNode)nds[i]).refreshNode();
            }
        }

        protected Node[] createNodes(Object obj) {
            DependencyPOMChange chng = (DependencyPOMChange)obj;
            IContentProvider provider = chng.getChangedContent();
            Lookup look = Lookups.fixed((Object[])new Object[]{chng, chng.getChangedContent()});
            return new Node[]{new DependencyNode(provider, DependenciesPanel.this.project, look)};
        }
    }

    private class ManagerChangeListener
    implements PropertyChangeListener {
        private ManagerChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != DependenciesPanel.this.manager) {
                return;
            }
            if ("selectedNodes".equals(evt.getPropertyName())) {
                DependenciesPanel.this.setDependency(DependenciesPanel.this.manager.getSelectedNodes());
            }
        }
    }
}

