/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.openide.util.Utilities;

public class FilesPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)FilesPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private boolean hasParent = false;
    private JSeparator jSeparator1;
    private JLabel lblBuild;
    private JLabel lblBuildState;
    private JLabel lblPOMFile;
    private JLabel lblPOMFileState;
    private JLabel lblProject;
    private JLabel lblProjectDir;
    private JLabel lblProjectState;
    private JLabel lblUser;
    private JLabel lblUserDirectory;
    private JLabel lblUserState;
    private JTextField txtBuild;
    private JTextField txtPOMFile;
    private JTextField txtProject;
    private JTextField txtProjectDir;
    private JTextField txtUser;
    private JTextField txtUserDirectory;
    private JLabel lblParentBuild;
    private JLabel lblParentBuildState;
    private JLabel lblParentPOMFile;
    private JLabel lblParentPOMFileState;
    private JLabel lblParentProject;
    private JLabel lblExtends;
    private JLabel lblParentProjectState;
    private JTextField txtParentBuild;
    private JTextField txtParentPOMFile;
    private JTextField txtParentProject;
    private JTextField txtExtends;

    public FilesPanel(boolean enable, MavenProject proj) {
        this.initComponents();
        this.project = proj;
        this.valObserver = null;
        this.lblProject.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocProject.png")));
        this.lblBuild.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocBuild.png")));
        this.lblUser.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocUser.png")));
        this.lblPOMFile.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocPomFile.png")));
        Project[] projs = proj.getContext().getPOMContext().getProjectLayers();
        if (projs.length > 1) {
            this.hasParent = true;
            this.initParentComponents();
            this.lblParentProject.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentProject.png")));
            this.lblParentBuild.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentBuild.png")));
            this.lblParentPOMFile.setIcon(new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentPOM.png")));
        }
        this.setEnableFields(enable);
    }

    public void setEnableFields(boolean enable) {
        this.txtBuild.setEditable(enable);
        this.txtPOMFile.setEditable(enable);
        this.txtProject.setEditable(enable);
        this.txtProjectDir.setEditable(enable);
        this.txtUser.setEditable(enable);
        this.txtUserDirectory.setEditable(enable);
        if (this.hasParent) {
            this.txtParentBuild.setEditable(enable);
            this.txtParentProject.setEditable(enable);
            this.txtParentPOMFile.setEditable(enable);
            this.txtExtends.setEditable(enable);
        }
    }

    private void initComponents() {
        this.lblProjectDir = new JLabel();
        this.txtProjectDir = new JTextField();
        this.lblPOMFile = new JLabel();
        this.txtPOMFile = new JTextField();
        this.lblPOMFileState = new JLabel();
        this.lblProject = new JLabel();
        this.txtProject = new JTextField();
        this.lblProjectState = new JLabel();
        this.lblBuild = new JLabel();
        this.txtBuild = new JTextField();
        this.lblBuildState = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblUserDirectory = new JLabel();
        this.txtUserDirectory = new JTextField();
        this.lblUser = new JLabel();
        this.txtUser = new JTextField();
        this.lblUserState = new JLabel();
        this.setLayout(new GridBagLayout());
        this.lblProjectDir.setText("Project Directory :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblProjectDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtProjectDir, gridBagConstraints);
        this.lblPOMFile.setText("POM File :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblPOMFile, gridBagConstraints);
        this.txtPOMFile.setMinimumSize(new Dimension(100, 28));
        this.txtPOMFile.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtPOMFile, gridBagConstraints);
        this.lblPOMFileState.setText("jLabel3");
        this.lblPOMFileState.setMaximumSize(new Dimension(80, 24));
        this.lblPOMFileState.setMinimumSize(new Dimension(80, 24));
        this.lblPOMFileState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblPOMFileState, gridBagConstraints);
        this.lblProject.setText("Project Properties :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblProject, gridBagConstraints);
        this.txtProject.setMinimumSize(new Dimension(100, 28));
        this.txtProject.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtProject, gridBagConstraints);
        this.lblProjectState.setText("jLabel5");
        this.lblProjectState.setMaximumSize(new Dimension(80, 24));
        this.lblProjectState.setMinimumSize(new Dimension(80, 24));
        this.lblProjectState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblProjectState, gridBagConstraints);
        this.lblBuild.setText("Build Properties :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblBuild, gridBagConstraints);
        this.txtBuild.setMinimumSize(new Dimension(100, 28));
        this.txtBuild.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtBuild, gridBagConstraints);
        this.lblBuildState.setText("jLabel9");
        this.lblBuildState.setMaximumSize(new Dimension(80, 24));
        this.lblBuildState.setMinimumSize(new Dimension(80, 24));
        this.lblBuildState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblBuildState, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblUserDirectory.setText("User Directory :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblUserDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtUserDirectory, gridBagConstraints);
        this.lblUser.setText("User Properies :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblUser, gridBagConstraints);
        this.txtUser.setMinimumSize(new Dimension(100, 28));
        this.txtUser.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtUser, gridBagConstraints);
        this.lblUserState.setText("jLabel8");
        this.lblUserState.setMaximumSize(new Dimension(80, 24));
        this.lblUserState.setMinimumSize(new Dimension(80, 24));
        this.lblUserState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblUserState, gridBagConstraints);
    }

    private void initParentComponents() {
        this.lblExtends = new JLabel();
        this.txtExtends = new JTextField();
        this.lblParentPOMFile = new JLabel();
        this.txtParentPOMFile = new JTextField();
        this.lblParentPOMFileState = new JLabel();
        this.lblParentProject = new JLabel();
        this.txtParentProject = new JTextField();
        this.lblParentProjectState = new JLabel();
        this.lblParentBuild = new JLabel();
        this.txtParentBuild = new JTextField();
        this.lblParentBuildState = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.lblExtends.setText("Extends :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblExtends, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtExtends, gridBagConstraints);
        this.lblParentPOMFile.setText("POM File :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblParentPOMFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtParentPOMFile, gridBagConstraints);
        this.lblParentPOMFileState.setMaximumSize(new Dimension(80, 24));
        this.lblParentPOMFileState.setMinimumSize(new Dimension(80, 24));
        this.lblParentPOMFileState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblParentPOMFileState, gridBagConstraints);
        this.lblParentProject.setText("Project Properties :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblParentProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtParentProject, gridBagConstraints);
        this.lblParentProjectState.setMaximumSize(new Dimension(80, 24));
        this.lblParentProjectState.setMinimumSize(new Dimension(80, 24));
        this.lblParentProjectState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblParentProjectState, gridBagConstraints);
        this.lblParentBuild.setText("Build Properties :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblParentBuild, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtParentBuild, gridBagConstraints);
        this.lblParentBuildState.setMaximumSize(new Dimension(80, 24));
        this.lblParentBuildState.setMinimumSize(new Dimension(80, 24));
        this.lblParentBuildState.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblParentBuildState, gridBagConstraints);
    }

    public void setResolveValues(boolean resolve) {
        this.txtBuild.setText("build.properties");
        this.txtProject.setText("project.properties");
        this.txtUser.setText("build.properties");
        this.txtPOMFile.setText("project.xml");
        this.txtProjectDir.setText(this.project.getContext().getProjectDirectory().toString());
        this.txtUserDirectory.setText(this.project.getContext().getUserDirectory().toString());
        File userFile = new File(this.project.getContext().getUserDirectory(), "build.properties");
        File projectFile = new File(this.project.getContext().getProjectDirectory(), "project.properties");
        File pomFile = new File(this.project.getContext().getProjectDirectory(), "project.xml");
        File buildFile = new File(this.project.getContext().getProjectDirectory(), "build.properties");
        if (userFile.exists()) {
            this.lblUserState.setText("");
        } else {
            this.lblUserState.setText("Doesn't exist");
        }
        if (buildFile.exists()) {
            this.lblBuildState.setText("");
        } else {
            this.lblBuildState.setText("Doesn't exist");
        }
        if (projectFile.exists()) {
            this.lblProjectState.setText("");
        } else {
            this.lblProjectState.setText("Doesn't exist");
        }
        if (pomFile.exists()) {
            this.lblPOMFileState.setText("");
        } else {
            this.lblPOMFileState.setText("Doesn't exist");
        }
        if (this.hasParent) {
            this.txtParentBuild.setText("build.properties");
            this.txtParentProject.setText("project.properties");
            Project[] projs = this.project.getContext().getPOMContext().getProjectLayers();
            File[] projFiles = this.project.getContext().getPOMContext().getProjectFiles();
            this.txtExtends.setText(projs[0].getExtend());
            this.txtParentPOMFile.setText(projFiles[1].getName());
        }
    }

    public List getChanges() {
        return Collections.EMPTY_LIST;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        return "";
    }
}

