/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.MailingList;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.ListModelPOMChange;
import org.mevenide.netbeans.project.customizer.MultiTextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.project.io.IContentProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class ListsPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)ListsPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private Listener listener;
    private OriginChange ocMailingLists;
    private OriginChange ocDummyMailingList;
    private DefaultListModel model;
    private ListModelPOMChange change;
    private MultiTextComponentPOMChange currentList;
    private boolean isResolvingValues = false;
    private boolean initialized;
    private JButton btnAdd;
    private JButton btnMailingLists;
    private JButton btnRemove;
    private JButton btnView;
    private JLabel lblArchive;
    private JLabel lblLists;
    private JLabel lblName;
    private JLabel lblSubscribe;
    private JLabel lblUnsubscribe;
    private JList lstLists;
    private JScrollPane spLists;
    private JTextField txtArchive;
    private JTextField txtName;
    private JTextField txtSubscribe;
    private JTextField txtUnsubscribe;

    public ListsPanel(MavenProject proj) {
        this.project = proj;
        this.ocDummyMailingList = LocationComboFactory.createPOMChange(this.project, false);
        this.initComponents();
        this.valObserver = null;
        this.setName(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.name"));
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = ListsPanel.this.txtArchive.getText().trim();
                url = ListsPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.lstLists.setSelectionMode(0);
        this.initialized = false;
    }

    private void initComponents() {
        this.lblLists = new JLabel();
        this.ocMailingLists = LocationComboFactory.createPOMChange(this.project, true);
        this.btnMailingLists = (JButton)this.ocMailingLists.getComponent();
        this.spLists = new JScrollPane();
        this.lstLists = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblArchive = new JLabel();
        this.txtArchive = new JTextField();
        this.btnView = new JButton();
        this.lblSubscribe = new JLabel();
        this.txtSubscribe = new JTextField();
        this.lblUnsubscribe = new JLabel();
        this.txtUnsubscribe = new JTextField();
        this.setLayout(new GridBagLayout());
        this.lblLists.setLabelFor(this.lstLists);
        this.lblLists.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.lblLists.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblLists, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.btnMailingLists, gridBagConstraints);
        this.spLists.setPreferredSize(new Dimension(300, 131));
        this.spLists.setViewportView(this.lstLists);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.spLists, gridBagConstraints);
        this.btnAdd.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.btnAdd.text"));
        this.btnAdd.setActionCommand("btnAdd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.btnRemove.text"));
        this.btnRemove.setActionCommand("btnRemove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtName, gridBagConstraints);
        this.lblArchive.setLabelFor(this.txtArchive);
        this.lblArchive.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.lblArchive.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblArchive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtArchive, gridBagConstraints);
        this.btnView.setText("View...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnView, gridBagConstraints);
        this.lblSubscribe.setLabelFor(this.txtSubscribe);
        this.lblSubscribe.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.lblLSubscribe.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblSubscribe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtSubscribe, gridBagConstraints);
        this.lblUnsubscribe.setLabelFor(this.txtUnsubscribe);
        this.lblUnsubscribe.setText(NbBundle.getMessage((Class)ListsPanel.class, (String)"ListsPanel.lblUnsubscribe.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblUnsubscribe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtUnsubscribe, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
        this.listener = new Listener();
        this.btnAdd.addActionListener(this.listener);
        this.btnRemove.addActionListener(this.listener);
        this.lstLists.addListSelectionListener(this.listener);
        this.txtName.addFocusListener(this.listener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnAdd.removeActionListener(this.listener);
        this.btnRemove.removeActionListener(this.listener);
        this.lstLists.removeListSelectionListener(this.listener);
        this.txtName.removeFocusListener(this.listener);
    }

    private void populateChangeInstances() {
        String key = "pom.mailingLists";
        int location = this.project.getProjectWalker().getLocation(key);
        ArrayList<MultiTextComponentPOMChange> oldValues = new ArrayList<MultiTextComponentPOMChange>();
        List orig = this.project.getOriginalMavenProject().getMailingLists();
        if (orig != null) {
            Iterator it = orig.iterator();
            while (it.hasNext()) {
                MailingList mlist = (MailingList)it.next();
                HashMap<String, String> vals = new HashMap<String, String>();
                vals.put("name", mlist.getName());
                vals.put("archive", mlist.getArchive());
                vals.put("subscribe", mlist.getSubscribe());
                vals.put("unsubscribe", mlist.getUnsubscribe());
                MultiTextComponentPOMChange change = new MultiTextComponentPOMChange("pom.mailingLists.mailingList", vals, location, this.createFieldMap(), this.ocDummyMailingList, false);
                oldValues.add(change);
            }
        }
        this.model = new DefaultListModel();
        this.lstLists.setModel(this.model);
        this.lstLists.setCellRenderer(new ListRenderer());
        this.change = new ListModelPOMChange(key, oldValues, location, this.model, this.ocMailingLists, true);
    }

    public void setResolveValues(boolean resolve) {
        this.isResolvingValues = resolve;
        this.resolveOneList(resolve, this.currentList);
        this.btnRemove.setEnabled(!resolve);
        this.btnAdd.setEnabled(!resolve);
    }

    private void resolveOneList(boolean resolve, MultiTextComponentPOMChange chng) {
        if (chng != null) {
            if (resolve) {
                IContentProvider prov = this.currentList.getChangedContent();
                HashMap<String, String> resolved = new HashMap<String, String>();
                String value = prov.getValue("name");
                if (value != null) {
                    resolved.put("name", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("archive")) != null) {
                    resolved.put("archive", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("subscribe")) != null) {
                    resolved.put("subscribe", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("unsubscribe")) != null) {
                    resolved.put("unsubscribe", this.project.getPropertyResolver().resolveString(value));
                }
                chng.setResolvedValues(resolved);
            } else {
                chng.resetToNonResolvedValue();
            }
        }
    }

    public List getChanges() {
        if (this.initialized) {
            boolean hasChanged = this.change.hasChanged();
            if (!hasChanged) {
                MultiTextComponentPOMChange chng;
                for (int i = 0; i < this.model.size() && !(hasChanged = (chng = (MultiTextComponentPOMChange)this.model.get(i)).hasChanged()); ++i) {
                }
            }
            if (hasChanged) {
                ArrayList<ListModelPOMChange> toReturn = new ArrayList<ListModelPOMChange>();
                toReturn.add(this.change);
                return toReturn;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    private int doValidateCheck() {
        if (this.txtName.getText().trim().length() == 0) {
            return 1;
        }
        return 0;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        String message = "";
        return message;
    }

    private HashMap createFieldMap() {
        HashMap<String, JTextField> fields = new HashMap<String, JTextField>();
        fields.put("name", this.txtName);
        fields.put("subscribe", this.txtSubscribe);
        fields.put("unsubscribe", this.txtUnsubscribe);
        fields.put("archive", this.txtArchive);
        return fields;
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MultiTextComponentPOMChange change = (MultiTextComponentPOMChange)value;
            String name = change.getValueFor("name");
            name = name == null || name.trim().length() == 0 ? "<Mailing list with no name>" : ListsPanel.this.project.getPropertyResolver().resolveString(name);
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    FocusListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if ("btnRemove".equals(e.getActionCommand())) {
                int index;
                ListsPanel.this.model.removeElementAt(index);
                for (index = ListsPanel.this.lstLists.getSelectedIndex(); index >= ListsPanel.this.model.size(); --index) {
                }
                if (index > -1) {
                    ListsPanel.this.lstLists.setSelectedIndex(index);
                }
            }
            if ("btnAdd".equals(e.getActionCommand())) {
                MultiTextComponentPOMChange newList = new MultiTextComponentPOMChange("pom.mailingLists.mailingList", new HashMap(), ListsPanel.this.change.getOldLocation(), ListsPanel.this.createFieldMap(), ListsPanel.this.ocDummyMailingList, false);
                if (ListsPanel.this.currentList != null) {
                    ListsPanel.this.currentList.detachListeners();
                }
                ListsPanel.this.model.addElement(newList);
                ListsPanel.this.lstLists.setSelectedValue(newList, true);
                ListsPanel.this.txtName.requestFocusInWindow();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (ListsPanel.this.currentList != null) {
                ListsPanel.this.currentList.detachListeners();
                ListsPanel.this.txtName.setText("");
                ListsPanel.this.txtUnsubscribe.setText("");
                ListsPanel.this.txtSubscribe.setText("");
                ListsPanel.this.txtArchive.setText("");
            }
            ListsPanel.this.lstLists.repaint();
            if (ListsPanel.this.lstLists.getSelectedIndex() == -1) {
                ListsPanel.this.currentList = null;
                ListsPanel.this.btnRemove.setEnabled(false);
            } else {
                ListsPanel.this.currentList = (MultiTextComponentPOMChange)ListsPanel.this.lstLists.getSelectedValue();
                ListsPanel.this.resolveOneList(ListsPanel.this.isResolvingValues, ListsPanel.this.currentList);
                ListsPanel.this.currentList.attachListeners();
                ListsPanel.this.btnRemove.setEnabled(true);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            ListsPanel.this.lstLists.repaint();
        }
    }
}

