/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.mevenide.netbeans.project.customizer.MavenPOMTreeChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.project.io.IContentProvider;

public class MultiTextComponentPOMChange
implements MavenPOMTreeChange {
    private String key;
    private Map values;
    private int location;
    private Map newValues;
    private int newLocation;
    private Map fields;
    private OriginChange origin;
    private Map listeners;
    private OrigListener orListener;
    private boolean ignore = false;

    public MultiTextComponentPOMChange(String keyParam, Map oldValues, int oldLocation, Map textfields, OriginChange oc) {
        this(keyParam, oldValues, oldLocation, textfields, oc, true);
    }

    public MultiTextComponentPOMChange(String keyParam, Map oldValues, int oldLocation, Map textfields, OriginChange oc, boolean attachListeners) {
        this.key = keyParam;
        this.values = oldValues;
        this.location = oldLocation;
        this.newValues = new HashMap(this.values);
        this.newLocation = oldLocation;
        this.fields = textfields;
        this.origin = oc;
        this.origin.setInitialLocationID(oldLocation);
        this.orListener = new OrigListener();
        this.listeners = new HashMap();
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JTextComponent field = (JTextComponent)entry.getValue();
            String val = (String)this.values.get(entry.getKey());
            if (attachListeners) {
                field.setText(val == null ? "" : val);
            }
            this.listeners.put(entry.getKey(), new DocListener((String)entry.getKey(), field));
        }
        if (attachListeners) {
            this.attachListeners();
        }
    }

    public void attachListeners() {
        this.origin.setChangeObserver(this.orListener);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JTextComponent field = (JTextComponent)entry.getValue();
            DocListener list = (DocListener)this.listeners.get(entry.getKey());
            field.getDocument().addDocumentListener(list);
        }
    }

    public void detachListeners() {
        this.origin.setChangeObserver(null);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JTextComponent field = (JTextComponent)entry.getValue();
            DocListener list = (DocListener)this.listeners.get(entry.getKey());
            field.getDocument().removeDocumentListener(list);
        }
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.origin.getComponent().setEnabled(true);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JTextComponent field = (JTextComponent)entry.getValue();
            String val = (String)this.newValues.get(entry.getKey());
            field.setText(val == null ? "" : val);
            field.setEditable(true);
        }
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public int getOldLocation() {
        return this.location;
    }

    public boolean hasChanged() {
        boolean toReturn = this.newLocation != this.location || !this.valuesEqual();
        return toReturn;
    }

    private boolean valuesEqual() {
        boolean equal;
        boolean bl = equal = this.values.keySet().containsAll(this.newValues.keySet()) && this.newValues.keySet().containsAll(this.values.keySet());
        if (equal) {
            Iterator it = this.values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String oldval = (String)entry.getValue();
                String newval = (String)this.newValues.get(entry.getKey());
                equal = oldval != null && newval != null ? oldval.equals(newval) : false;
                if (equal) continue;
                return false;
            }
        }
        return equal;
    }

    public void setResolvedValues(HashMap resvalues) {
        this.ignore = true;
        this.origin.getComponent().setEnabled(false);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            JTextComponent field = (JTextComponent)ent.getValue();
            field.setEditable(false);
            String val = (String)resvalues.get(ent.getKey());
            field.setText(val != null ? val : "");
        }
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.startIgnoringChanges();
        this.stopIgnoringChanges();
    }

    public String getPath() {
        return this.key;
    }

    public IContentProvider getChangedContent() {
        return new SimpleContentProvider(new HashMap(this.newValues));
    }

    public String getValueFor(String key) {
        return (String)this.newValues.get(key);
    }

    private static class SimpleContentProvider
    implements IContentProvider {
        private Map vals;

        public SimpleContentProvider(Map values) {
            this.vals = values;
        }

        public List getProperties() {
            return Collections.EMPTY_LIST;
        }

        public IContentProvider getSubContentProvider(String key) {
            return null;
        }

        public List getSubContentProviderList(String parentKey, String childKey) {
            return null;
        }

        public String getValue(String key) {
            return (String)this.vals.get(key);
        }

        public List getValueList(String parentKey, String childKey) {
            return (List)this.vals.get(parentKey);
        }
    }

    private class OrigListener
    implements OriginChange.ChangeObserver {
        private OrigListener() {
        }

        public void locationChanged() {
            if (MultiTextComponentPOMChange.this.ignore) {
                return;
            }
            MultiTextComponentPOMChange.this.newLocation = MultiTextComponentPOMChange.this.origin.getSelectedLocationID();
            if (MultiTextComponentPOMChange.this.newLocation < 0) {
                MultiTextComponentPOMChange.this.ignore = true;
                MultiTextComponentPOMChange.this.newValues.clear();
                Iterator it = MultiTextComponentPOMChange.this.fields.values().iterator();
                while (it.hasNext()) {
                    JTextComponent field = (JTextComponent)it.next();
                    field.setText("");
                }
                MultiTextComponentPOMChange.this.ignore = false;
            }
        }
    }

    private class DocListener
    implements DocumentListener {
        private String id;
        private JTextComponent textField;

        private DocListener(String keyid, JTextComponent component) {
            this.id = keyid;
            this.textField = component;
        }

        private void update() {
            if (MultiTextComponentPOMChange.this.ignore) {
                return;
            }
            MultiTextComponentPOMChange.this.newValues.put(this.id, this.textField.getText());
            if (MultiTextComponentPOMChange.this.origin.getSelectedLocationID() == -1 || MultiTextComponentPOMChange.this.origin.getSelectedLocationID() == -2) {
                MultiTextComponentPOMChange.this.origin.setAction(0);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }
    }
}

