/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Resource;
import org.mevenide.netbeans.project.nodes.DirScannerSubClass;
import org.mevenide.netbeans.project.nodes.ShowAllResourcesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

class ResourceFilterNode
extends FilterNode {
    private static Log logger = LogFactory.getLog((Class)ResourceFilterNode.class);
    private Resource resource;
    private File root;
    private boolean isIncluded;

    ResourceFilterNode(Node original, File resPath, Resource res, boolean included) {
        super(original, (Children)new ResFilterChildren(original, resPath, res));
        this.resource = res;
        this.root = resPath;
        DataObject dobj = (DataObject)this.getLookup().lookup(DataObject.class);
        this.isIncluded = included;
    }

    public Action[] getActions(boolean context) {
        return super.getActions(context);
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.isIncluded) {
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        Image retValue = super.getOpenedIcon(type);
        if (this.isIncluded) {
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public String getDisplayName() {
        String retValue = super.getDisplayName();
        return retValue;
    }

    public String getHtmlDisplayName() {
        String retValue;
        if (!this.isIncluded) {
            retValue = this.getDisplayName();
            try {
                retValue = "<I>" + XMLUtil.toAttributeValue((String)retValue) + "</I>";
            }
            catch (CharConversionException exc) {
                logger.debug((Object)("conversion failed for =" + retValue), (Throwable)exc);
            }
        } else {
            retValue = super.getHtmlDisplayName();
        }
        return retValue;
    }

    static class ResFilterChildren
    extends FilterNode.Children {
        private Resource resource;
        private File root;
        private FileObject rootFO;
        private PropertyChangeListener list;
        private Node orig;

        ResFilterChildren(Node original, File rootpath, Resource res) {
            super(original);
            this.root = rootpath;
            this.orig = original;
            this.rootFO = FileUtil.toFileObject((File)this.root);
            this.resource = res;
            this.list = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ResFilterChildren.this.doRefreshKeys();
                }
            };
        }

        private void doRefreshKeys() {
            Node[] nds = this.orig.getChildren().getNodes();
            for (int i = 0; i < nds.length; ++i) {
                boolean isIncluded;
                File file;
                DataObject dobj = (DataObject)nds[i].getLookup().lookup(class$org$openide$loaders$DataObject == null ? ResourceFilterNode.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dobj == null || (file = FileUtil.toFile((FileObject)dobj.getPrimaryFile())) == null || (isIncluded = DirScannerSubClass.checkIncluded(dobj.getPrimaryFile(), this.rootFO, this.resource))) continue;
                this.refreshKey(nds[i]);
            }
        }

        protected Node[] createNodes(Object obj) {
            File file;
            DataObject dobj = (DataObject)((Node)obj).getLookup().lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceFilterNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dobj != null && (file = FileUtil.toFile((FileObject)dobj.getPrimaryFile())) != null) {
                if (!DirScannerSubClass.checkVisible(file, this.root)) {
                    return new Node[0];
                }
                boolean isIncluded = DirScannerSubClass.checkIncluded(dobj.getPrimaryFile(), this.rootFO, this.resource);
                if (ShowAllResourcesAction.getInstance().isShowingAll()) {
                    ResourceFilterNode n = new ResourceFilterNode((Node)obj, this.root, this.resource, isIncluded);
                    return new Node[]{n};
                }
                if (isIncluded) {
                    ResourceFilterNode n = new ResourceFilterNode((Node)obj, this.root, this.resource, isIncluded);
                    return new Node[]{n};
                }
                return new Node[0];
            }
            Node origos = (Node)obj;
            return new Node[]{origos.cloneNode()};
        }

        protected void removeNotify() {
            super.removeNotify();
            ShowAllResourcesAction.getInstance().removePropertyChangeListener(this.list);
        }

        protected void addNotify() {
            super.addNotify();
            ShowAllResourcesAction.getInstance().addPropertyChangeListener(this.list);
        }
    }
}

