/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputProcessorFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.output.AnnouncementOutputListenerProvider;
import org.mevenide.netbeans.project.output.CheckstyleOutputListenerProvider;
import org.mevenide.netbeans.project.output.FindbugsOutputListenerProvider;
import org.mevenide.netbeans.project.output.JavaOutputListenerProvider;
import org.mevenide.netbeans.project.output.PmdOutputListenerProvider;
import org.mevenide.netbeans.project.output.TestOutputListenerProvider;
import org.mevenide.netbeans.project.output.ViewInBrowseProcessor;
import org.openide.util.Lookup;

public final class DefaultOutputProcessorFactory
implements OutputProcessorFactory {
    public static Set getAllProcessors(MavenProject project) {
        Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(OutputProcessorFactory.class));
        Iterator it = res.allInstances().iterator();
        HashSet results = new HashSet();
        while (it.hasNext()) {
            OutputProcessorFactory fact = (OutputProcessorFactory)it.next();
            results.addAll(fact.createProcessorsSet(project));
        }
        return results;
    }

    public Set createProcessorsSet(MavenProject project) {
        String docs;
        HashSet<AbstractOutputProcessor> processors = new HashSet<AbstractOutputProcessor>();
        processors.add(new TestOutputListenerProvider(project));
        processors.add(new JavaOutputListenerProvider(project));
        processors.add(new AnnouncementOutputListenerProvider(project));
        processors.add(new PmdOutputListenerProvider(project));
        processors.add(new CheckstyleOutputListenerProvider(project));
        processors.add(new FindbugsOutputListenerProvider(project));
        String javadoc = project.getPropertyResolver().getResolvedValue("maven.javadoc.destdir");
        if (javadoc != null) {
            File fil = new File(javadoc, "index.html");
            String[] goals = new String[]{"maven-javadoc-plugin:report:"};
            processors.add(new ViewInBrowseProcessor(goals, fil, "Do you want to view the javadoc in browser?", 10));
        }
        if ((docs = project.getPropertyResolver().getResolvedValue("maven.docs.dest")) != null) {
            File fil = new File(docs, "index.html");
            String[] goals = new String[]{"site:"};
            processors.add(new ViewInBrowseProcessor(goals, fil, "Do you want to view the generated site in browser?", 100));
        }
        return processors;
    }
}

