/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestOutputListenerProvider
extends AbstractOutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)TestOutputListenerProvider.class);
    private static final String[] TESTGOALS = new String[]{"test:test:", "test:single:", "test:match:"};
    private Pattern failPattern = Pattern.compile("\\s*\\[junit\\] \\[ERROR\\] TEST (.*) FAILED.*");
    private MavenProject project;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public TestOutputListenerProvider(MavenProject proj) {
        this.project = proj;
    }

    public String[] getWatchedGoals() {
        return TESTGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isInWatchedGoals(line) && (match = this.failPattern.matcher(line)).matches()) {
            String test = match.group(1);
            visitor.setOutputListener(new TestOutputListener(this.project, test), true);
        }
    }

    private static class StacktraceOutputListener
    implements OutputListener {
        private EditorCookie cookie;
        private int line;

        public StacktraceOutputListener(EditorCookie cook, int ln) {
            this.cookie = cook;
            this.line = ln - 1;
        }

        public void outputLineSelected(OutputEvent ev) {
            this.cookie.getLineSet().getCurrent(this.line).show(1);
        }

        public void outputLineAction(OutputEvent ev) {
            this.cookie.getLineSet().getCurrent(this.line).show(2);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class TestOutputListener
    implements OutputListener {
        private MavenProject project;
        private String testname;

        public TestOutputListener(MavenProject proj, String test) {
            this.testname = test;
            this.project = proj;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            File testDir = new File(this.project.getTestSrcDirectory());
            String replace = this.testname.replace('.', '/');
            File testFile = new File(testDir, replace + ".java");
            FileObject fo = FileUtil.toFileObject((File)testFile);
            String repDir = this.project.getPropertyResolver().getResolvedValue("maven.test.reportsDirectory");
            if (repDir == null) {
                StatusDisplayer.getDefault().setStatusText("Maven: Cannot resolve property maven.test.reportsDirectory.");
                logger.error((Object)"Cannot resolve property maven.test.reportsDirectory.");
                return;
            }
            File dir = new File(repDir);
            if (dir.exists()) {
                File testResult = new File(dir, "TEST-" + this.testname + ".txt");
                FileObject fo2 = FileUtil.toFileObject((File)testResult);
                if (fo != null) {
                    String nm = this.testname.lastIndexOf(46) > -1 ? this.testname.substring(this.testname.lastIndexOf(46)) : this.testname;
                    this.openLog(fo2, "Test " + nm, fo);
                }
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openLog(FileObject fo, String title, FileObject testFile) {
            try {
                IOProvider.getDefault().getIO(title, false).getOut().reset();
            }
            catch (Exception exc) {
                logger.error((Object)"Exception while resetting output", (Throwable)exc);
            }
            InputOutput io = IOProvider.getDefault().getIO(title, false);
            io.select();
            BufferedReader reader = null;
            OutputWriter writer = io.getOut();
            String line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                Pattern linePattern = Pattern.compile("\\sat (.*)\\((.*)\\.java\\:(.*)\\)");
                ClassPath classPath = ClassPath.getClassPath((FileObject)testFile, (String)"classpath/execute");
                while ((line = reader.readLine()) != null) {
                    Matcher match = linePattern.matcher(line);
                    StacktraceOutputListener list = null;
                    if (match.matches()) {
                        String packageName;
                        String resourceName;
                        FileObject resource;
                        String method = match.group(1);
                        String file = match.group(2);
                        String lineNum = match.group(3);
                        int index = method.indexOf(file);
                        if (index > -1 && (resource = classPath.findResource(resourceName = (packageName = method.substring(0, index).replace('.', '/')) + file + ".class")) != null) {
                            FileObject root = classPath.findOwnerRoot(resource);
                            URL url = URLMapper.findURL((FileObject)root, (int)0);
                            SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)url);
                            FileObject[] rootz = res.getRoots();
                            for (int i = 0; i < rootz.length; ++i) {
                                File rootFile = FileUtil.toFile((FileObject)rootz[i]);
                                File java = new File(rootFile, packageName + file + ".java");
                                FileObject javaFo = FileUtil.toFileObject((File)java);
                                if (javaFo == null) continue;
                                DataObject obj = DataObject.find((FileObject)javaFo);
                                EditorCookie cook = (EditorCookie)obj.getCookie(class$org$openide$cookies$EditorCookie == null ? TestOutputListenerProvider.class$("org.openide.cookies.EditorCookie") : class$org$openide$cookies$EditorCookie);
                                int lineInt = Integer.parseInt(lineNum);
                                list = new StacktraceOutputListener(cook, lineInt);
                            }
                        }
                    }
                    if (list != null) {
                        writer.println(line, list);
                        continue;
                    }
                    writer.println(line);
                }
            }
            catch (IOException exc) {
                logger.warn((Object)"exception IO", (Throwable)exc);
            }
            finally {
                writer.close();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
    }
}

