/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.queries;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private static final Log logger = LogFactory.getLog((Class)MavenFileOwnerQueryImpl.class);
    private Set set;
    private Object LOCK = new Object();

    public MavenFileOwnerQueryImpl() {
        logger.debug((Object)"MavenFileOwnerQueryImpl()");
        this.set = new HashSet();
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof MavenFileOwnerQueryImpl) {
                return (MavenFileOwnerQueryImpl)obj;
            }
            logger.debug((Object)("fileOwnwequeryImpl=" + obj.getClass()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProject(MavenProject project) {
        Object object = this.LOCK;
        synchronized (object) {
            this.set.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProject(MavenProject project) {
        Object object = this.LOCK;
        synchronized (object) {
            this.set.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedProjects() {
        Object object = this.LOCK;
        synchronized (object) {
            return new HashSet(this.set);
        }
    }

    public Project getOwner(URI uri) {
        File file = new File(uri);
        return this.getOwner(file);
    }

    public Project getOwner(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project getOwner(File file) {
        HashSet currentProjects;
        Object object = this.LOCK;
        synchronized (object) {
            currentProjects = new HashSet(this.set);
        }
        try {
            IDependencyResolver resolver = DependencyResolverFactory.getFactory().newInstance(file.getAbsolutePath());
            String version = resolver.guessVersion();
            String artifactid = resolver.guessArtifactId();
            String groupid = resolver.guessGroupId();
            Iterator it = currentProjects.iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                org.apache.maven.project.Project proj = project.getOriginalMavenProject();
                IPropertyResolver res = project.getPropertyResolver();
                if (version == null || !this.doCompare(version, res.resolveString(proj.getCurrentVersion())) || artifactid == null || !this.doCompare(artifactid, res.resolveString(proj.getArtifactId())) && !this.doCompare(artifactid, res.resolveString(proj.getId())) || groupid == null || !this.doCompare(groupid, res.resolveString(proj.getGroupId())) && !groupid.equals(artifactid)) continue;
                logger.debug((Object)("found project=" + project.getDisplayName()));
                return project;
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Something wrong with resolver.", (Throwable)exc);
        }
        return null;
    }

    private boolean doCompare(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return one.trim().equals(two.trim());
    }
}

